/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.forms;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.I00acres.isql.forms.frmiSQLMain;
import org.I00acres.isql.util.iSQLUtilites;

public final class frmHistoryBrowser
extends JDialog
implements ActionListener {
    private JButton m_btnExecute = new JButton(iSQLUtilites.getString("Execute"));
    private JButton m_btnClear = new JButton(iSQLUtilites.getString("Clear_All"));
    private JButton m_btnExit = new JButton(iSQLUtilites.getString("Exit"));
    private JButton m_btnSelect = new JButton(iSQLUtilites.getString("Select"));
    private JList mHistoryList = new JList();
    private frmiSQLMain Owner;

    public static final void showDialog(frmiSQLMain Owner) {
        frmHistoryBrowser dlg = new frmHistoryBrowser(Owner);
        dlg.show();
    }

    private frmHistoryBrowser(frmiSQLMain Owner) {
        super(frmiSQLMain.zParent, iSQLUtilites.getString("HistoryBrowser_Title"), true);
        this.Owner = Owner;
        try {
            this.initUI();
        }
        catch (Throwable t) {
            iSQLUtilites.HandleException(t, "frmHistoryBrowser()::initUI()", true);
        }
    }

    private void initUI() throws Exception {
        JPanel cp = (JPanel)this.getContentPane();
        cp.setLayout(new GridBagLayout());
        this.m_btnClear.addActionListener(this);
        this.m_btnClear.setToolTipText(iSQLUtilites.getString("HIST_Removes_All"));
        this.m_btnExecute.setToolTipText(iSQLUtilites.getString("HIST_Execute_The_Selected"));
        this.m_btnExecute.addActionListener(this);
        this.m_btnSelect.setToolTipText(iSQLUtilites.getString("HIST_Select_This_History"));
        this.m_btnSelect.addActionListener(this);
        this.m_btnExit.addActionListener(this);
        this.mHistoryList.setListData(this.Owner.getCurrentSQLHistory().toArray());
        this.mHistoryList.addMouseListener(new ListMouseAdapter());
        cp.add((Component)new JLabel(iSQLUtilites.getString("HIST_Recent_SQL_Query")), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 5, 5));
        cp.add((Component)new JScrollPane(this.mHistoryList), new GridBagConstraints(0, 1, 1, 4, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 5, 5));
        cp.add((Component)this.m_btnClear, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 18, 2, new Insets(5, 5, 5, 5), 5, 5));
        cp.add((Component)this.m_btnSelect, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 18, 2, new Insets(5, 5, 5, 5), 5, 5));
        cp.add((Component)this.m_btnExecute, new GridBagConstraints(1, 3, 1, 1, 0.0, 1.0, 18, 2, new Insets(5, 5, 5, 5), 5, 5));
        cp.add((Component)this.m_btnExit, new GridBagConstraints(1, 4, 1, 1, 0.0, 1.0, 18, 2, new Insets(5, 5, 5, 5), 5, 5));
        cp.setMinimumSize(new Dimension(320, 200));
        cp.setPreferredSize(new Dimension(320, 200));
        this.pack();
        this.setLocationRelativeTo(this.Owner);
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src.equals(this.m_btnExit)) {
            this.dispose();
        } else if (src.equals(this.m_btnClear)) {
            this.Owner.clearHistory();
            this.dispose();
        } else if (src.equals(this.m_btnSelect)) {
            this.Owner.setCurrentQuery(this.mHistoryList.getSelectedIndex());
            this.dispose();
        } else if (src.equals(this.m_btnExecute)) {
            try {
                this.Owner.performQuery(this.mHistoryList.getSelectedValue().toString(), false);
                this.dispose();
            }
            catch (Exception exception) {}
        }
    }

    private class ListMouseAdapter
    extends MouseAdapter {
        ListMouseAdapter() {
        }

        public void mousePressed(MouseEvent evt) {
            if (evt.getClickCount() == 2) {
                frmHistoryBrowser.this.actionPerformed(new ActionEvent(frmHistoryBrowser.this.m_btnExecute, 0, ""));
            }
        }
    }
}

