/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.forms;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.I00acres.isql.forms.frmExportWizard;
import org.I00acres.isql.forms.frmPrinterPreview;
import org.I00acres.isql.forms.frmWarningViewer;
import org.I00acres.isql.forms.frmiSQLMain;
import org.I00acres.isql.swing.MetaTreeCellRenderer;
import org.I00acres.isql.swing.SortableHeaderRenderer;
import org.I00acres.isql.swing.TableSelector;
import org.I00acres.isql.swing.action.iSQLActionConstants;
import org.I00acres.isql.swing.table.iSQLTableModel;
import org.I00acres.isql.swing.tree.MetaDataModel;
import org.I00acres.isql.util.iSQLUtilites;
import org.I00acres.lib.sql.DatabaseConnection;

public final class frmMetaExplorer
extends JFrame {
    private boolean JDBCDebug = false;
    private boolean JDBCVerb = false;
    private final Properties EMPTY_TABLE_DATA = new Properties();
    private String currentCatalog;
    private String currentSchema;
    private DatabaseMetaData databaseMetaData;
    private DatabaseConnection databaseConnection;
    private ActionListener actionHandler = new ActionHandler();
    private ChangeListener changeHandler = new ChangeHandler();
    private TreeHandler treeHandler = new TreeHandler();
    private TableSelector metadataFilterer;
    private TableSelector primaryTableSelector;
    private TableSelector foriegnTableSelector;
    private MetaDataModel metadataModel = null;
    private iSQLTableModel crossRefData = new iSQLTableModel();
    private iSQLTableModel metadataData = new iSQLTableModel();
    private JButton btnPrint = new JButton(iSQLUtilites.loadToolbarIconResource("Print"));
    private JButton btnPreview = new JButton(iSQLUtilites.loadToolbarIconResource("PrintPreview"));
    private JButton btnDeleteRowColumn = new JButton(iSQLUtilites.loadToolbarIconResource("RowDelete"));
    private JButton btnExportTable = new JButton(iSQLUtilites.loadToolbarIconResource("Export"));
    private JButton btnOK = new JButton(iSQLUtilites.getString("Ok"));
    private JButton btnGetXRef = new JButton(iSQLUtilites.loadIconResource("Query24"));
    private JTable metadataJTable = new JTable(this.metadataData);
    private JTable xRefJTable = new JTable(this.crossRefData);
    private JTabbedPane baseContainer = new JTabbedPane(1);
    private JTree metadataJTree = new JTree();
    private JPanel contentPanel = new JPanel(new BorderLayout());
    private JSplitPane mJDBCContainer = new JSplitPane(1, new JScrollPane(this.metadataJTree), new JScrollPane(this.metadataJTable));

    private frmMetaExplorer(DatabaseConnection pCurrentConnection) {
        super(iSQLUtilites.getString("JDBCExplorer_Title"));
        this.setDefaultCloseOperation(2);
        this.databaseConnection = pCurrentConnection;
        this.databaseMetaData = this.databaseConnection.getDatabaseInformation();
        this.metadataModel = new MetaDataModel(this.databaseConnection);
        this.JDBCDebug = DatabaseConnection.getDebugOn();
        this.JDBCVerb = DatabaseConnection.getVerboseOn();
        this.EMPTY_TABLE_DATA.setProperty(iSQLUtilites.getString("Error"), iSQLUtilites.getString("Data_Unavailable"));
        try {
            this.initUI();
        }
        catch (Throwable t) {
            iSQLUtilites.HandleException(t, "frmMetaExplorer()::initUI()");
        }
    }

    public void dispose() {
        this.databaseConnection.flushConnectionInfo();
        super.dispose();
    }

    public static int showDialog(DatabaseConnection connection) {
        frmMetaExplorer dlg = null;
        try {
            dlg = new frmMetaExplorer(connection);
            dlg.pack();
            ((Component)dlg).setSize(640, 480);
            ((Component)dlg).setLocation(frmiSQLMain.zParent.getLocationOnScreen());
            dlg.show();
        }
        catch (Error err) {
            JOptionPane.showConfirmDialog(frmiSQLMain.zParent, String.valueOf(iSQLUtilites.getString("JDBCExplorerNotSupported")) + "\n" + iSQLUtilites.getString("Error") + err, iSQLUtilites.getString("Fatal_Error_Occured"), 0, 0);
            return -1;
        }
        catch (Exception ex) {
            JOptionPane.showConfirmDialog(frmiSQLMain.zParent, String.valueOf(iSQLUtilites.getString("JDBCExplorerNotSupported")) + "\n" + iSQLUtilites.getString("Error") + ex, iSQLUtilites.getString("General_Exception_Occured"), 0, 0);
            return -1;
        }
        catch (Throwable t) {
            iSQLUtilites.HandleException(t, iSQLUtilites.getString("JDBCExplorerNotSupported"), true);
            return -1;
        }
        return 0;
    }

    private void initUI() throws Exception {
        try {
            ((Frame)this).setIconImage(((ImageIcon)iSQLUtilites.loadIconResource("Database24")).getImage());
        }
        catch (Exception exception) {}
        this.metadataFilterer = new TableSelector(this.databaseMetaData, false);
        this.primaryTableSelector = new TableSelector(this.databaseMetaData, true);
        this.foriegnTableSelector = new TableSelector(this.databaseMetaData, true);
        this.primaryTableSelector.setBorder(BorderFactory.createTitledBorder(iSQLUtilites.getString("Select_Primary_Table")));
        this.foriegnTableSelector.setBorder(BorderFactory.createTitledBorder(iSQLUtilites.getString("Select_Foreign_Table")));
        this.metadataFilterer.addChangeListener(this.changeHandler);
        this.metadataModel.setCatalog(this.metadataFilterer.getSelectedCatalog(), false);
        this.metadataModel.setSchema(this.metadataFilterer.getSelectedSchema(), false);
        this.metadataModel.reload();
        this.btnPreview.addActionListener(this.actionHandler);
        this.btnPrint.addActionListener(this.actionHandler);
        this.btnDeleteRowColumn.addActionListener(this.actionHandler);
        this.btnExportTable.addActionListener(this.actionHandler);
        this.btnOK.addActionListener(this.actionHandler);
        this.btnGetXRef.addActionListener(this.actionHandler);
        this.btnOK.setPreferredSize(new Dimension(2 * this.btnOK.getPreferredSize().width, this.btnOK.getPreferredSize().height));
        iSQLUtilites.lockComponentToPerferredSize(this.btnOK);
        this.btnPreview.setToolTipText(iSQLActionConstants.CMD_PRINTPREV_S_DESC);
        this.btnPrint.setToolTipText(iSQLActionConstants.CMD_PRINT_S_DESC);
        this.btnDeleteRowColumn.setToolTipText(iSQLActionConstants.CMD_ROWDELE_S_DESC);
        this.btnExportTable.setToolTipText(iSQLActionConstants.CMD_TABLEEXP_S_DESC);
        this.btnOK.setToolTipText(iSQLUtilites.getString("Close_This_Dialog"));
        this.btnGetXRef.setToolTipText(iSQLUtilites.getString("Query_Cross_References"));
        this.btnExportTable.setEnabled(false);
        JToolBar tb = new JToolBar(0);
        tb.setFloatable(false);
        tb.add(this.btnPreview);
        tb.add(this.btnPrint);
        tb.addSeparator();
        tb.add(this.btnDeleteRowColumn);
        tb.add(this.btnExportTable);
        tb.add(this.btnGetXRef);
        tb.add(Box.createVerticalGlue());
        iSQLUtilites.TableMouseAdapter ml = new iSQLUtilites.TableMouseAdapter(this.actionHandler);
        this.metadataJTable.addMouseListener(ml);
        this.metadataJTable.getTableHeader().addMouseListener(ml);
        this.metadataJTable.getTableHeader().setDefaultRenderer(new SortableHeaderRenderer(this.metadataJTable));
        this.xRefJTable.addMouseListener(ml);
        this.xRefJTable.getTableHeader().addMouseListener(ml);
        this.xRefJTable.getTableHeader().setDefaultRenderer(new SortableHeaderRenderer(this.xRefJTable));
        this.metadataJTree.setModel(this.metadataModel);
        this.metadataJTree.addTreeExpansionListener(this.treeHandler);
        this.metadataJTree.addTreeSelectionListener(this.treeHandler);
        this.metadataJTree.setCellRenderer(new MetaTreeCellRenderer());
        this.mJDBCContainer.setDividerLocation(this.metadataJTree.getPreferredSize().width + this.mJDBCContainer.getDividerSize());
        JPanel jdbcContainer = new JPanel(new BorderLayout());
        jdbcContainer.add((Component)this.mJDBCContainer, "Center");
        jdbcContainer.add((Component)this.metadataFilterer, "North");
        JPanel xrefPanel = new JPanel(new GridBagLayout());
        Insets ins = new Insets(1, 1, 1, 1);
        xrefPanel.add((Component)this.primaryTableSelector, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, ins, 0, 0));
        xrefPanel.add((Component)this.foriegnTableSelector, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, ins, 0, 0));
        xrefPanel.add((Component)new JScrollPane(this.xRefJTable), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, ins, 0, 0));
        this.baseContainer.addChangeListener(this.changeHandler);
        this.baseContainer.addTab(iSQLUtilites.getString("Database_Objects"), jdbcContainer);
        this.baseContainer.addTab(iSQLUtilites.getString("Cross_Refrences"), xrefPanel);
        this.contentPanel.add((Component)this.baseContainer, "Center");
        this.getContentPane().add((Component)tb, "North");
        this.getContentPane().add((Component)this.contentPanel, "Center");
        tb = new JToolBar(0);
        tb.add(Box.createHorizontalGlue());
        tb.add(this.btnOK);
        tb.setFloatable(false);
        this.getContentPane().add((Component)tb, "South");
        this.pack();
    }

    private void modelResultSet(ResultSet set) {
        this.modelResultSet(set, false);
    }

    private void modelResultSet(ResultSet set, boolean isCrossRefrence) {
        block16: {
            try {
                if (set != null) {
                    if (isCrossRefrence) {
                        this.crossRefData.setData(set);
                    } else {
                        this.metadataData.setData(set);
                    }
                } else if (isCrossRefrence) {
                    this.crossRefData.setData(this.EMPTY_TABLE_DATA);
                } else {
                    this.metadataData.setData(this.EMPTY_TABLE_DATA);
                }
            }
            catch (Exception exception) {
                if (isCrossRefrence) {
                    this.crossRefData.setData(this.EMPTY_TABLE_DATA);
                }
                this.metadataData.setData(this.EMPTY_TABLE_DATA);
            }
            if (isCrossRefrence) {
                iSQLUtilites.optimizeTableView(this.xRefJTable);
            } else {
                iSQLUtilites.optimizeTableView(this.metadataJTable);
            }
            try {
                frmWarningViewer.addResultsetWarnings(set.getWarnings());
            }
            catch (Throwable throwable) {}
            try {
                if (set != null) {
                    set.close();
                }
            }
            catch (Throwable t) {
                if (!this.JDBCVerb) break block16;
                iSQLUtilites.HandleException(t, null, this.JDBCDebug);
            }
        }
    }

    private class ChangeHandler
    implements ChangeListener {
        ChangeHandler() {
        }

        public void stateChanged(ChangeEvent ce) {
            Object src = ce.getSource();
            if (src == frmMetaExplorer.this.metadataFilterer) {
                frmMetaExplorer.this.currentCatalog = frmMetaExplorer.this.metadataFilterer.getSelectedCatalog();
                frmMetaExplorer.this.currentSchema = frmMetaExplorer.this.metadataFilterer.getSelectedSchema();
                frmMetaExplorer.this.metadataModel.setCatalog(frmMetaExplorer.this.currentCatalog, false);
                frmMetaExplorer.this.metadataModel.setSchema(frmMetaExplorer.this.currentSchema, false);
                frmMetaExplorer.this.metadataModel.reload();
            } else if (src == frmMetaExplorer.this.baseContainer) {
                frmMetaExplorer.this.btnGetXRef.setEnabled(frmMetaExplorer.this.baseContainer.getSelectedIndex() == 1);
                if (frmMetaExplorer.this.baseContainer.getSelectedIndex() == 1) {
                    frmMetaExplorer.this.btnExportTable.setEnabled(frmMetaExplorer.this.xRefJTable.getRowCount() >= 1);
                } else {
                    frmMetaExplorer.this.btnExportTable.setEnabled(frmMetaExplorer.this.metadataJTree.getSelectionCount() >= 1);
                }
            }
        }
    }

    private class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            block22: {
                frmMetaExplorer.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    try {
                        boolean xRefTabSelected = frmMetaExplorer.this.baseContainer.getSelectedIndex() == 1;
                        JTable table = xRefTabSelected ? frmMetaExplorer.this.xRefJTable : frmMetaExplorer.this.metadataJTable;
                        Object obj = e.getSource();
                        if (obj == frmMetaExplorer.this.btnPreview) {
                            frmPrinterPreview.showPrintPreviewDialog(frmMetaExplorer.this, table, xRefTabSelected ? iSQLUtilites.getString("Cross_Refrences") : frmMetaExplorer.this.metadataJTree.getSelectionPath().toString());
                            break block22;
                        }
                        if (obj == frmMetaExplorer.this.metadataJTable) {
                            if (frmMetaExplorer.this.metadataJTable.getRowSelectionAllowed()) {
                                frmMetaExplorer.this.btnDeleteRowColumn.setIcon(iSQLUtilites.loadToolbarIconResource("RowDelete"));
                                frmMetaExplorer.this.btnDeleteRowColumn.setToolTipText(iSQLActionConstants.CMD_ROWDELE_S_DESC);
                            } else {
                                frmMetaExplorer.this.btnDeleteRowColumn.setIcon(iSQLUtilites.loadToolbarIconResource("ColumnDelete"));
                                frmMetaExplorer.this.btnDeleteRowColumn.setToolTipText(iSQLActionConstants.CMD_COLDELE_S_DESC);
                            }
                            break block22;
                        }
                        if (obj == frmMetaExplorer.this.btnExportTable) {
                            frmExportWizard wiz = new frmExportWizard((Frame)frmMetaExplorer.this, table.getModel());
                            wiz.show();
                            break block22;
                        }
                        if (obj == frmMetaExplorer.this.btnGetXRef) {
                            try {
                                if (frmMetaExplorer.this.primaryTableSelector.compareSelection(frmMetaExplorer.this.foriegnTableSelector)) {
                                    JOptionPane.showMessageDialog(frmMetaExplorer.this, iSQLUtilites.getString("Cross_Reference_Check_Error", frmMetaExplorer.this.primaryTableSelector.getSelectedTable()));
                                    Object var7_7 = null;
                                    frmMetaExplorer.this.setCursor(Cursor.getPredefinedCursor(0));
                                    return;
                                }
                                frmMetaExplorer.this.modelResultSet(frmMetaExplorer.this.databaseMetaData.getCrossReference(frmMetaExplorer.this.primaryTableSelector.getSelectedCatalog(), frmMetaExplorer.this.primaryTableSelector.getSelectedSchema(), frmMetaExplorer.this.primaryTableSelector.getSelectedTable(), frmMetaExplorer.this.foriegnTableSelector.getSelectedCatalog(), frmMetaExplorer.this.foriegnTableSelector.getSelectedSchema(), frmMetaExplorer.this.foriegnTableSelector.getSelectedTable()), true);
                            }
                            catch (SQLException sqle) {
                                frmMetaExplorer.this.modelResultSet(null, true);
                                if (frmMetaExplorer.this.JDBCVerb) {
                                    iSQLUtilites.HandleException(sqle, null, frmMetaExplorer.this.JDBCDebug);
                                }
                                JOptionPane.showMessageDialog(frmMetaExplorer.this, iSQLUtilites.getString("Cross_Reference_Error", new String[]{frmMetaExplorer.this.primaryTableSelector.getSelectedTable(), sqle.getMessage()}));
                            }
                            frmMetaExplorer.this.btnExportTable.setEnabled(true);
                            break block22;
                        }
                        if (obj == frmMetaExplorer.this.btnOK) {
                            frmMetaExplorer.this.dispose();
                        } else if (obj == frmMetaExplorer.this.btnPrint) {
                            frmPrinterPreview.print(table, xRefTabSelected ? iSQLUtilites.getString("Cross_Refrences") : frmMetaExplorer.this.metadataJTree.getSelectionPath().toString());
                        } else if (obj == frmMetaExplorer.this.btnDeleteRowColumn) {
                            if (table.getRowSelectionAllowed()) {
                                iSQLUtilites.removeSelectedRows(table);
                            } else if (table.getColumnSelectionAllowed()) {
                                iSQLUtilites.removeSelectedColumns(table);
                            }
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    frmMetaExplorer.this.setCursor(Cursor.getPredefinedCursor(0));
                    throw throwable;
                }
            }
            Object var7_9 = null;
            frmMetaExplorer.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private class TreeHandler
    implements TreeSelectionListener,
    TreeExpansionListener {
        TreeHandler() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            block34: {
                if (!frmMetaExplorer.this.btnExportTable.isEnabled()) {
                    frmMetaExplorer.this.btnExportTable.setEnabled(true);
                }
                frmMetaExplorer.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    try {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
                        if (!frmMetaExplorer.this.metadataModel.isTableTypeNode(node)) {
                            switch (node.getParent().getIndex(node) - frmMetaExplorer.this.metadataModel.getTableTypeCount()) {
                                case 0: {
                                    frmMetaExplorer.this.metadataData.setData(frmMetaExplorer.this.databaseConnection.getConnectionInformation());
                                    break;
                                }
                                case 1: {
                                    frmMetaExplorer.this.modelResultSet(frmMetaExplorer.this.databaseMetaData.getSchemas());
                                    break;
                                }
                                case 2: {
                                    frmMetaExplorer.this.modelResultSet(frmMetaExplorer.this.databaseMetaData.getCatalogs());
                                    break;
                                }
                                case 3: {
                                    frmMetaExplorer.this.modelResultSet(frmMetaExplorer.this.databaseMetaData.getTableTypes());
                                    break;
                                }
                                case 4: {
                                    frmMetaExplorer.this.modelResultSet(frmMetaExplorer.this.databaseMetaData.getTypeInfo());
                                    break;
                                }
                                case 5: {
                                    frmMetaExplorer.this.modelResultSet(frmMetaExplorer.this.databaseMetaData.getUDTs(frmMetaExplorer.this.currentCatalog, frmMetaExplorer.this.currentSchema, null, null));
                                    break;
                                }
                                case 6: {
                                    frmMetaExplorer.this.modelResultSet(frmMetaExplorer.this.databaseMetaData.getProcedures(frmMetaExplorer.this.currentCatalog, frmMetaExplorer.this.currentSchema, null));
                                    break;
                                }
                                default: {
                                    frmMetaExplorer.this.modelResultSet(null);
                                    break;
                                }
                            }
                            break block34;
                        }
                        switch (node.getLevel()) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                frmMetaExplorer.this.modelResultSet(frmMetaExplorer.this.databaseMetaData.getTables(frmMetaExplorer.this.currentCatalog, frmMetaExplorer.this.currentSchema, null, new String[]{node.getUserObject().toString()}));
                                break;
                            }
                            case 2: {
                                frmMetaExplorer.this.modelResultSet(frmMetaExplorer.this.databaseMetaData.getTables(frmMetaExplorer.this.currentCatalog, frmMetaExplorer.this.currentSchema, node.getUserObject().toString(), new String[]{node.getPath()[1].toString()}));
                                break;
                            }
                            case 3: {
                                String str = node.getUserObject().toString();
                                String Table = node.getPath()[2].toString();
                                try {
                                    if (str.equalsIgnoreCase(iSQLUtilites.getString("JDBC_Columns"))) {
                                        frmMetaExplorer.this.modelResultSet(frmMetaExplorer.this.databaseMetaData.getColumns(frmMetaExplorer.this.currentCatalog, frmMetaExplorer.this.currentSchema, Table, null));
                                        break;
                                    }
                                    if (str.equalsIgnoreCase(iSQLUtilites.getString("JDBC_Indicies"))) {
                                        frmMetaExplorer.this.modelResultSet(frmMetaExplorer.this.databaseMetaData.getIndexInfo(frmMetaExplorer.this.currentCatalog, frmMetaExplorer.this.currentSchema, Table, false, false));
                                        break;
                                    }
                                    if (str.equalsIgnoreCase(iSQLUtilites.getString("JDBC_Primary_Keys"))) {
                                        frmMetaExplorer.this.modelResultSet(frmMetaExplorer.this.databaseMetaData.getPrimaryKeys(frmMetaExplorer.this.currentCatalog, frmMetaExplorer.this.currentSchema, Table));
                                        break;
                                    }
                                    if (str.equalsIgnoreCase(iSQLUtilites.getString("JDBC_Exported_Keys"))) {
                                        frmMetaExplorer.this.modelResultSet(frmMetaExplorer.this.databaseMetaData.getExportedKeys(frmMetaExplorer.this.currentCatalog, frmMetaExplorer.this.currentSchema, Table));
                                        break;
                                    }
                                    if (str.equalsIgnoreCase(iSQLUtilites.getString("JDBC_Imported_Keys"))) {
                                        frmMetaExplorer.this.modelResultSet(frmMetaExplorer.this.databaseMetaData.getImportedKeys(frmMetaExplorer.this.currentCatalog, frmMetaExplorer.this.currentSchema, Table));
                                        break;
                                    }
                                    if (str.equalsIgnoreCase(iSQLUtilites.getString("JDBC_Version_Columns"))) {
                                        frmMetaExplorer.this.modelResultSet(frmMetaExplorer.this.databaseMetaData.getVersionColumns(frmMetaExplorer.this.currentCatalog, frmMetaExplorer.this.currentSchema, Table));
                                        break;
                                    }
                                    if (str.equalsIgnoreCase(iSQLUtilites.getString("JDBC_Table_Privileges"))) {
                                        frmMetaExplorer.this.modelResultSet(frmMetaExplorer.this.databaseMetaData.getTablePrivileges(frmMetaExplorer.this.currentCatalog, frmMetaExplorer.this.currentSchema, Table));
                                        break;
                                    }
                                    if (str.equalsIgnoreCase(iSQLUtilites.getString("JDBC_Column_Privileges"))) {
                                        frmMetaExplorer.this.modelResultSet(frmMetaExplorer.this.databaseMetaData.getColumnPrivileges(frmMetaExplorer.this.currentCatalog, frmMetaExplorer.this.currentSchema, Table, null));
                                    }
                                }
                                catch (Throwable t) {
                                    iSQLUtilites.HandleException(t, iSQLUtilites.getString("JDBC_MetaData_View_Error", node.toString()), frmMetaExplorer.this.JDBCDebug);
                                }
                                break;
                            }
                            case 4: {
                                String Table = node.getPath()[2].toString();
                                frmMetaExplorer.this.modelResultSet(frmMetaExplorer.this.databaseMetaData.getColumns(frmMetaExplorer.this.currentCatalog, frmMetaExplorer.this.currentSchema, Table, node.getUserObject().toString()));
                                break;
                            }
                            default: {
                                frmMetaExplorer.this.modelResultSet(null);
                                break;
                            }
                        }
                    }
                    catch (SQLException sqle) {
                        frmMetaExplorer.this.modelResultSet(null);
                        if (frmMetaExplorer.this.JDBCVerb) {
                            iSQLUtilites.HandleException(sqle, null, frmMetaExplorer.this.JDBCDebug);
                        }
                    }
                    catch (Throwable throwable) {
                        frmMetaExplorer.this.modelResultSet(null);
                    }
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    frmMetaExplorer.this.setCursor(Cursor.getPredefinedCursor(0));
                    throw throwable;
                }
            }
            Object var7_10 = null;
            frmMetaExplorer.this.setCursor(Cursor.getPredefinedCursor(0));
        }

        public void treeExpanded(TreeExpansionEvent event) {
            frmMetaExplorer.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                try {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
                    if (frmMetaExplorer.this.metadataModel.isUnacachedNode(node)) {
                        switch (node.getLevel()) {
                            case 1: {
                                frmMetaExplorer.this.metadataModel.loadTableTypeNode(node, node.toString());
                                break;
                            }
                            case 2: {
                                frmMetaExplorer.this.metadataModel.loadTableChildNodes(node);
                                break;
                            }
                            case 3: {
                                frmMetaExplorer.this.metadataModel.loadColumnChildNodes(node);
                                break;
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    frmMetaExplorer.this.modelResultSet(null);
                    if (frmMetaExplorer.this.JDBCVerb) {
                        iSQLUtilites.HandleException(t, null, frmMetaExplorer.this.JDBCDebug);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                frmMetaExplorer.this.setCursor(Cursor.getPredefinedCursor(0));
                throw throwable;
            }
            Object var4_6 = null;
            frmMetaExplorer.this.setCursor(Cursor.getPredefinedCursor(0));
        }

        public void treeCollapsed(TreeExpansionEvent evt) {
        }
    }
}

