/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.forms;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLWarning;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.I00acres.isql.swing.table.SQLWarningTableModel;
import org.I00acres.isql.util.iSQLUtilites;

public class frmWarningViewer
extends JDialog
implements ListSelectionListener,
ActionListener {
    static SQLWarningTableModel ConnectionWarnings = new SQLWarningTableModel();
    static SQLWarningTableModel StatementWarnings = new SQLWarningTableModel();
    static SQLWarningTableModel ResultsetWarnings = new SQLWarningTableModel();
    private JTable mConnectionWarnings = new JTable(ConnectionWarnings);
    private JTable mStatementWarnings = new JTable(StatementWarnings);
    private JTable mResultsetWarnings = new JTable(ResultsetWarnings);
    private JTabbedPane mWarningContainer = new JTabbedPane(1);
    private JTextArea mWarningMessage = new JTextArea();
    private JToolBar mToolBar = new JToolBar(0);
    private JButton mClearTab = new JButton();
    private JButton btnOK = new JButton(iSQLUtilites.getString("Ok"));

    static {
        WarningListener Listener = new WarningListener();
        ConnectionWarnings.addTableModelListener(Listener);
        StatementWarnings.addTableModelListener(Listener);
        ResultsetWarnings.addTableModelListener(Listener);
    }

    public static int showDialog(Frame Owner) {
        try {
            frmWarningViewer dlg = new frmWarningViewer(Owner);
            dlg.show();
            return 0;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return -1;
        }
    }

    private frmWarningViewer(Frame Owner) {
        super(Owner, iSQLUtilites.getString("Warning_Viewer_Title"), false);
        try {
            this.initUI();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private synchronized void initUI() throws Exception {
        JPanel mainContent = new JPanel(new GridLayout(2, 1));
        this.mConnectionWarnings.getSelectionModel().addListSelectionListener(this);
        this.mResultsetWarnings.getSelectionModel().addListSelectionListener(this);
        this.mStatementWarnings.getSelectionModel().addListSelectionListener(this);
        this.mToolBar.setFloatable(false);
        this.mToolBar.add(this.mClearTab);
        this.mClearTab.setIcon(iSQLUtilites.loadToolbarIconResource("Delete"));
        this.mClearTab.setToolTipText(iSQLUtilites.getString("Clear_Warning_Tab_Tip"));
        this.mClearTab.addActionListener(this);
        this.mWarningContainer.addTab(iSQLUtilites.getString("Connection_Warning_Tab"), iSQLUtilites.loadIconResource("WebComponent16"), new JScrollPane(this.mConnectionWarnings));
        this.mWarningContainer.addTab(iSQLUtilites.getString("Statement_Warning_Tab"), iSQLUtilites.loadIconResource("J2EEApplication16"), new JScrollPane(this.mStatementWarnings));
        this.mWarningContainer.addTab(iSQLUtilites.getString("Resultset_Warning_Tab"), iSQLUtilites.loadIconResource("Table16"), new JScrollPane(this.mResultsetWarnings));
        JPanel MessageViewer = new JPanel(new BorderLayout());
        MessageViewer.add((Component)new JLabel(String.valueOf(iSQLUtilites.getString("SQL_Warning_Message")) + " ::"), "North");
        MessageViewer.add((Component)new JScrollPane(this.mWarningMessage), "Center");
        mainContent.add(this.mWarningContainer);
        mainContent.add(MessageViewer);
        this.btnOK.addActionListener(this);
        this.btnOK.setPreferredSize(new Dimension(2 * this.btnOK.getPreferredSize().width, this.btnOK.getPreferredSize().height));
        iSQLUtilites.lockComponentToPerferredSize(this.btnOK);
        this.btnOK.setToolTipText(iSQLUtilites.getString("Close_This_Dialog"));
        JToolBar tb = new JToolBar(0);
        tb.add(Box.createHorizontalGlue());
        tb.add(this.btnOK);
        tb.setFloatable(false);
        this.getContentPane().add((Component)mainContent, "Center");
        this.getContentPane().add((Component)tb, "South");
        this.getContentPane().add((Component)this.mToolBar, "North");
        ((Component)this).setSize(470, 360);
        this.validate();
        this.setLocationRelativeTo(this.getOwner());
    }

    public static void addConnectionWarnings(SQLWarning warnings) {
        ConnectionWarnings.setData(warnings, true);
    }

    public static void setConnectionWarnings(SQLWarning warnings) {
        ConnectionWarnings.setData(warnings, false);
    }

    public static void addStatementWarnings(SQLWarning warnings) {
        StatementWarnings.setData(warnings, true);
    }

    public static void setStatementWarnings(SQLWarning warnings) {
        StatementWarnings.setData(warnings, false);
    }

    public static void addResultsetWarnings(SQLWarning warnings) {
        ResultsetWarnings.setData(warnings, true);
    }

    public static void setResultsetWarnings(SQLWarning warnings) {
        ResultsetWarnings.setData(warnings, false);
    }

    public static void clearAll() {
        ResultsetWarnings.clearTable();
        StatementWarnings.clearTable();
        ConnectionWarnings.clearTable();
    }

    public void valueChanged(ListSelectionEvent e) {
        String tab = this.mWarningContainer.getTitleAt(this.mWarningContainer.getSelectedIndex());
        if (tab.equalsIgnoreCase(iSQLUtilites.getString("Connection_Warning_Tab"))) {
            this.mWarningMessage.setText(ConnectionWarnings.getWarningMessageForRow(e.getFirstIndex()));
        } else if (tab.equalsIgnoreCase(iSQLUtilites.getString("Statement_Warning_Tab"))) {
            this.mWarningMessage.setText(StatementWarnings.getWarningMessageForRow(e.getFirstIndex()));
        } else if (tab.equalsIgnoreCase(iSQLUtilites.getString("Resultset_Warning_Tab"))) {
            this.mWarningMessage.setText(ResultsetWarnings.getWarningMessageForRow(e.getFirstIndex()));
        }
    }

    public void actionPerformed(ActionEvent e) {
        String tab;
        Object src = e.getSource();
        if (src == this.btnOK) {
            this.dispose();
        }
        if ((tab = this.mWarningContainer.getTitleAt(this.mWarningContainer.getSelectedIndex())).equalsIgnoreCase(iSQLUtilites.getString("Connection_Warning_Tab"))) {
            ConnectionWarnings.clearTable();
            this.mConnectionWarnings.repaint();
        } else if (tab.equalsIgnoreCase(iSQLUtilites.getString("Statement_Warning_Tab"))) {
            StatementWarnings.clearTable();
            this.mStatementWarnings.repaint();
        } else if (tab.equalsIgnoreCase(iSQLUtilites.getString("Resultset_Warning_Tab"))) {
            ResultsetWarnings.clearTable();
            this.mResultsetWarnings.repaint();
        }
    }

    private static class WarningListener
    implements TableModelListener {
        WarningListener() {
        }

        public void tableChanged(TableModelEvent e) {
            if (e.getType() != 1) {
                return;
            }
            String Source = "";
            if (e.getSource() == ConnectionWarnings) {
                Source = iSQLUtilites.getString("Connection_Warning_Tab");
            } else if (e.getSource() == StatementWarnings) {
                Source = iSQLUtilites.getString("Statement_Warning_Tab");
            } else if (e.getSource() == ResultsetWarnings) {
                Source = iSQLUtilites.getString("Resultset_Warning_Tab");
            }
            System.out.println(String.valueOf(e.getLastRow() - e.getFirstRow() + 1) + " " + Source);
        }
    }
}

