/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.forms;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.I00acres.isql.forms.frmBatchRunner;
import org.I00acres.isql.forms.frmExportWizard;
import org.I00acres.isql.forms.frmHistoryBrowser;
import org.I00acres.isql.forms.frmImportWizard;
import org.I00acres.isql.forms.frmMetaExplorer;
import org.I00acres.isql.forms.frmPrefrencesEditor;
import org.I00acres.isql.forms.frmPrinterPreview;
import org.I00acres.isql.forms.frmServiceManager;
import org.I00acres.isql.forms.frmTableTools;
import org.I00acres.isql.forms.frmWarningViewer;
import org.I00acres.isql.iSQLAboutBox;
import org.I00acres.isql.swing.AuthDialog;
import org.I00acres.isql.swing.JConsole;
import org.I00acres.isql.swing.JTextComponentPopup;
import org.I00acres.isql.swing.MutableContentViewer;
import org.I00acres.isql.swing.ResultSetContainer;
import org.I00acres.isql.swing.SortableHeaderRenderer;
import org.I00acres.isql.swing.action.JCheckBoxAction;
import org.I00acres.isql.swing.action.iSQLActionManager;
import org.I00acres.isql.swing.iSQLActionPopup;
import org.I00acres.isql.swing.iSQLCommandConsole;
import org.I00acres.isql.swing.iSQLFileToolBar;
import org.I00acres.isql.swing.iSQLMenuBar;
import org.I00acres.isql.swing.iSQLResultSetToolBar;
import org.I00acres.isql.swing.table.ResultSetTableModel;
import org.I00acres.isql.util.iSQLConfig;
import org.I00acres.isql.util.iSQLUtilites;
import org.I00acres.lib.sql.DatabaseConnection;
import org.I00acres.lib.sql.ResultSetUtilities;
import org.I00acres.lib.sql.ResultSetViewer;
import org.I00acres.lib.swing.ActionManager;
import org.I00acres.lib.util.xProperties;

public final class frmiSQLMain
extends JComponent
implements ResultSetViewer,
SwingConstants {
    static JFrame zParent;
    private static final Icon ICON_CONSOLE_LIGHT;
    private static final Icon ICON_CONSOLE_DARK;
    private static final Icon ICON_TABLE;
    private static final KeyStroke KEYSTROKE_DELETE;
    private ActionManagerHandler actionHandler = new ActionManagerHandler();
    private TextActionHandler textActionHandler = new TextActionHandler();
    private ChangeListener tabChangeHandler = new TabChangeHandler();
    private iSQLConfig isqlConfig = iSQLConfig.getInstance();
    private JLabel lblStatus = new JLabel("", 2);
    private JLabel lblCaretLocation = new JLabel("    0:0    ", 0);
    private JLabel lblAutoCommit = new JLabel(" " + iSQLUtilites.getString("AutoCommit_ON") + " ", 0);
    private JPanel panelStatusContainer = new JPanel(new GridBagLayout());
    private JPanel panelConsoleContainer = new JPanel(new BorderLayout());
    private JPanel panelResultSetContaier = new JPanel(new BorderLayout());
    private Font defaultTableFont = this.isqlConfig.getFontProperty("Resultset.Data");
    private JConsole iSQLConsole = new JConsole();
    private JScrollPane mConsoleScroller = new JScrollPane(this.iSQLConsole);
    private MutableContentViewer mDataInspector = new MutableContentViewer();
    private JTextComponentPopup mConsolePopup = new JTextComponentPopup();
    private JSplitPane mIOSplitPane = new JSplitPane(0);
    private JSplitPane mRootsplitPane = new JSplitPane(0, this.mIOSplitPane, this.panelConsoleContainer);
    private MouseAdapter tableMouseAdapter = new iSQLUtilites.TableMouseAdapter(this.actionHandler);
    private iSQLFileToolBar toolbarFile = null;
    private iSQLResultSetToolBar toolbarResultSet = null;
    private iSQLMenuBar mainMenuBar = null;
    private StringBuffer lastQuery = new StringBuffer("");
    private String currentStatus = "";
    private DatabaseConnection databaseConnection;
    private iSQLCommandConsole sqlCommandConsole;
    private iSQLActionManager actionManager;
    private ResultSetContainer resultTabContainer = new ResultSetContainer(1, this.isqlConfig.getIntProperty("General.MaxResultSetCount"));
    private JTabbedPane consoleTabContainer = new JTabbedPane(2);
    private boolean refreshflag = false;
    private iSQLActionPopup tablePopupMenu = new iSQLActionPopup();

    static {
        ICON_CONSOLE_LIGHT = iSQLUtilites.loadIconResource("ConsoleLight16");
        ICON_CONSOLE_DARK = iSQLUtilites.loadIconResource("Console16");
        ICON_TABLE = iSQLUtilites.loadIconResource("Table16");
        KEYSTROKE_DELETE = iSQLUtilites.createKeyStroke(127, 0);
    }

    public void setJMenuBar(JMenuBar pMenuBar) {
        if (pMenuBar instanceof iSQLMenuBar) {
            if (this.mainMenuBar == null) {
                this.mainMenuBar = (iSQLMenuBar)pMenuBar;
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void setActionManager(ActionManager mgr) {
        if (mgr instanceof iSQLActionManager) {
            if (this.actionManager == null) {
                this.actionManager = (iSQLActionManager)mgr;
                this.sqlCommandConsole.setActionManager(this.actionManager);
                this.actionManager.addActionListener(this.actionHandler);
                this.actionManager.addItemListener(this.actionHandler);
                this.actionManager.addPropertyChangeListener(this.actionHandler);
                this.tablePopupMenu.addAction(this.actionManager.getAction("18"));
                this.tablePopupMenu.addAction(this.actionManager.getAction("13"));
                this.tablePopupMenu.addAction(this.actionManager.getAction("38"));
                this.createFileToolBar();
                this.createResultSetToolBar();
                if (this.isqlConfig.getBooleanProperty("JDBC.Use-Startup") && ((Hashtable)this.isqlConfig).containsKey("JDBC.Startup-Service")) {
                    String s = this.isqlConfig.getStringProperty("JDBC.Startup-Service");
                    this.InsertConsoleMessage(iSQLUtilites.getString("Auto_Connect_Message", s));
                    this.performServiceChange(s);
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public JTextComponent getDefaultTextComponent() {
        return this.sqlCommandConsole.getTextComponent();
    }

    public frmiSQLMain(JFrame Owner) {
        zParent = Owner;
        try {
            this.initUI();
        }
        catch (Throwable t) {
            iSQLUtilites.HandleException(t, iSQLUtilites.getString("Fatal_Error_Occured"), true);
            System.exit(-1);
        }
        this.initLogging();
    }

    public void setStatus(String status) {
        this.lblStatus.setText(iSQLUtilites.getString("Status_Label", new String[]{iSQLUtilites.getString("Status"), status}));
    }

    public void InsertConsoleMessage(String Message) {
        this.iSQLConsole.append(String.valueOf(Message) + "\n");
    }

    public synchronized void setDefaultFocus() {
        this.sqlCommandConsole.getTextComponent().requestFocus();
    }

    public synchronized void setCurrentQuery(int historyIndex) {
        this.sqlCommandConsole.setHIstoryElement(historyIndex);
    }

    public synchronized void clearHistory() {
        this.sqlCommandConsole.clearHistory();
    }

    public Collection getCurrentSQLHistory() {
        return this.sqlCommandConsole.getHistory();
    }

    public void actionRefreshTableView() {
        if (!this.isValidDatabaseConnection() || this.resultTabContainer.getSelectedIndex() < 0) {
            this.showInvalidConnection();
            return;
        }
        this.refreshflag = true;
        this.performQuery(this.resultTabContainer.getSelectedToolTip(), false);
    }

    public DatabaseConnection getDatabaseConnection() {
        return this.databaseConnection;
    }

    public void setFont(Font fnt) {
        this.defaultTableFont = fnt;
    }

    public void setInputConsoleFont(Font fnt) {
        this.sqlCommandConsole.updateFont(fnt);
    }

    public void setInputConsoleColor(Color fg, Color bg) {
        this.sqlCommandConsole.updateColor(fg, bg);
    }

    public void setMaxTabCount(int tabCount) {
        this.resultTabContainer.setMaxTabCount(tabCount);
    }

    public void saveCurrentHistory() {
        File f = null;
        if (this.isqlConfig.getBooleanProperty("General.UseDiscreteHistory")) {
            if (this.databaseConnection == null) {
                return;
            }
            f = this.isqlConfig.getLastHistoryLocation(this.databaseConnection);
        } else {
            f = this.isqlConfig.getLastHistoryLocation();
        }
        this.saveSQLHistory(f, false);
    }

    public void saveSQLHistory(boolean useSaveAs) {
        try {
            File f;
            if (useSaveAs) {
                f = iSQLUtilites.saveSystemFile(zParent);
                if (f == null) {
                    return;
                }
            } else {
                f = new File(iSQLConfig.getiSQLSubDir(iSQLUtilites.getString("History")), String.valueOf(iSQLUtilites.getString("History")) + System.currentTimeMillis() + ".sql");
            }
            this.saveSQLHistory(f, true);
        }
        catch (Exception exception) {}
    }

    public void performWebCheck(boolean override) {
        try {
            this.InsertConsoleMessage(iSQLUtilites.getString("Checking_For_Updated_iSQL"));
            Object[] res = this.isqlConfig.performWebCheck();
            int updatetype = this.isqlConfig.getIntProperty("Advanced.AutoVersionCheck.Type");
            if (updatetype == 0 && res[0].toString().equalsIgnoreCase("Beta") && !override || !((Boolean)res[2]).booleanValue()) {
                this.InsertConsoleMessage(iSQLUtilites.getString("No_Update_Available"));
            } else if (((Boolean)res[2]).booleanValue()) {
                this.InsertConsoleMessage(iSQLUtilites.getString("New_Version_Available"));
                this.InsertConsoleMessage(String.valueOf(iSQLUtilites.getString("Version_Type_" + res[0])) + " :: " + res[1]);
            }
        }
        catch (Exception e) {
            iSQLUtilites.HandleException(e, iSQLUtilites.getString("Web_Check_Error"));
        }
    }

    public synchronized Object modelResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                try {
                    ResultSetTableModel model = new ResultSetTableModel(rs, this.lastQuery.toString());
                    JTable table = null;
                    boolean refreshSameTab = this.isqlConfig.getBooleanProperty("General.RefreshSameTab");
                    if (refreshSameTab && this.refreshflag) {
                        table = this.getActiveTable();
                    }
                    if (table == null) {
                        table = new JTable();
                        table.setFont(this.defaultTableFont);
                        FontMetrics fm = ((Component)table).getFontMetrics(this.defaultTableFont);
                        table.putClientProperty("JPopupMenu", this.tablePopupMenu);
                        table.setRowHeight(fm.getHeight() + 2);
                        table.addMouseListener(this.tableMouseAdapter);
                        table.getTableHeader().addMouseListener(this.tableMouseAdapter);
                        table.getTableHeader().setDefaultRenderer(new SortableHeaderRenderer(table));
                        table.getActionMap().put("KEYSTROKE_DELETE", this.actionManager.getAction("24"));
                        table.getInputMap().put(KEYSTROKE_DELETE, "KEYSTROKE_DELETE");
                    }
                    table.setModel(model);
                    String TabString = "";
                    try {
                        TabString = ResultSetUtilities.getResultString(this.isqlConfig.getProperty("General.ResultTabFmt"), rs, table.getRowCount(), this.databaseConnection);
                    }
                    catch (Throwable t) {
                        iSQLUtilites.HandleException(t, "", true);
                        TabString = String.valueOf(this.databaseConnection.getConnectionName()) + "(" + table.getRowCount() + ")";
                    }
                    if (!refreshSameTab || !this.refreshflag) {
                        JScrollPane res = new JScrollPane(table);
                        this.resultTabContainer.addTab(TabString, ICON_TABLE, res, this.lastQuery.toString());
                    }
                    if (this.isqlConfig.getBooleanProperty("JDBC.EchoRecordCount")) {
                        this.InsertConsoleMessage(iSQLUtilites.getString("Number_Of_Records", "" + model.getRowCount()));
                    }
                    if (!this.refreshflag) {
                        this.resultTabContainer.setSelectedIndex(this.resultTabContainer.getTabCount() - 1);
                    }
                    iSQLUtilites.optimizeTableView(this.getActiveTable());
                    try {
                        frmWarningViewer.addResultsetWarnings(rs.getWarnings());
                    }
                    catch (Throwable throwable) {}
                    try {
                        frmWarningViewer.addStatementWarnings(rs.getStatement().getWarnings());
                    }
                    catch (Throwable throwable) {}
                    Integer n = new Integer(model.getRowCount());
                    Object var9_10 = null;
                    zParent.setCursor(Cursor.getDefaultCursor());
                    return n;
                }
                catch (Throwable t) {
                    iSQLUtilites.HandleException(t, iSQLUtilites.getString("Query_Exception"));
                    Object var9_11 = null;
                    zParent.setCursor(Cursor.getDefaultCursor());
                    return null;
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                zParent.setCursor(Cursor.getDefaultCursor());
                throw throwable;
            }
        }
        System.runFinalization();
        return new Integer(0);
    }

    protected void toggleResultSetDataView(JTable table, boolean switchdata) {
        if (table != null) {
            Action newAction;
            ResultSetTableModel model = (ResultSetTableModel)table.getModel();
            if (switchdata) {
                table.setAutoResizeMode(0);
            }
            if (model.isShowingMetadata()) {
                if (switchdata) {
                    model.showResultSetData();
                    newAction = this.actionManager.getAction("33");
                } else {
                    newAction = this.actionManager.getAction("32");
                }
            } else if (switchdata) {
                model.showMetaData();
                newAction = this.actionManager.getAction("32");
            } else {
                newAction = this.actionManager.getAction("33");
            }
            if (switchdata) {
                iSQLUtilites.optimizeTableView(this.getActiveTable());
            }
            if (this.toolbarResultSet != null) {
                this.toolbarResultSet.toggleResultSetViewAction(newAction);
            }
            this.mainMenuBar.toggleResultSetViewAction(newAction);
        }
    }

    protected void toggleLockAction(int tab, boolean doAction) {
        if (tab >= 0) {
            Action newAction;
            if (this.resultTabContainer.isTabLocked(tab)) {
                if (doAction) {
                    this.resultTabContainer.unlockTab(tab);
                    newAction = this.actionManager.getAction("35");
                } else {
                    newAction = this.actionManager.getAction("36");
                }
            } else if (doAction) {
                this.resultTabContainer.lockTab(tab);
                newAction = this.actionManager.getAction("36");
            } else {
                newAction = this.actionManager.getAction("35");
            }
            if (this.toolbarResultSet != null) {
                this.toolbarResultSet.toggleLockAction(newAction);
            }
            this.mainMenuBar.toggleLockAction(newAction);
        }
    }

    protected void toggleColumnDeleteAction(JTable table, boolean doAction) {
        Action newAction = null;
        if (table != null) {
            if (table.getRowSelectionAllowed()) {
                if (doAction) {
                    iSQLUtilites.removeSelectedRows(table);
                    return;
                }
                newAction = this.actionManager.getAction("24");
            } else if (table.getColumnSelectionAllowed()) {
                if (doAction) {
                    iSQLUtilites.removeSelectedColumns(table);
                    return;
                }
                newAction = this.actionManager.getAction("25");
            }
            if (this.toolbarResultSet != null) {
                this.toolbarResultSet.updateRowColumnDeleteAction(newAction);
            }
            table.getActionMap().put("DELETE", newAction);
            this.mainMenuBar.toggleDeleteColumnRowAction(newAction);
        }
    }

    protected void handleActionEvent(ActionEvent evt) {
        boolean isShiftClick = (evt.getModifiers() & 1) == 1;
        boolean isCtrlClick = (evt.getModifiers() & 2) == 2;
        Object data = null;
        int action = evt.getID();
        switch (action) {
            case 511: {
                this.toggleColumnDeleteAction(this.getActiveTable(), false);
                break;
            }
            case 64768: {
                this.sqlCommandConsole.getTextComponent().setText(evt.getActionCommand());
                break;
            }
            case 4: {
                frmServiceManager.showDialog(zParent, this);
                this.mainMenuBar.refreshServiceMenu(this.isqlConfig.getAvailableServices());
                break;
            }
            case 767: {
                int col = Integer.parseInt(evt.getActionCommand());
                int row = evt.getModifiers();
                data = this.getActiveTable().getValueAt(row, col);
            }
            case 38: {
                int row;
                int col;
                if (data == null) {
                    col = this.getActiveTable().getSelectedColumn();
                    row = this.getActiveTable().getSelectedRow();
                    data = row < 0 || col < 0 ? null : this.getActiveTable().getValueAt(row, col);
                }
                this.mDataInspector.setContent(data);
                if (this.consoleTabContainer.getSelectedIndex() == 1) break;
                this.consoleTabContainer.setSelectedIndex(1);
                break;
            }
            case 13: {
                iSQLUtilites.copySelectedCellsToClipBoard(this.getActiveTable());
                break;
            }
            case 31: {
                this.performDisconnect();
                break;
            }
            case 35: 
            case 36: {
                this.toggleLockAction(this.resultTabContainer.getSelectedIndex(), true);
                break;
            }
            case 34: {
                this.resultTabContainer.removeUnlockedTabs();
                break;
            }
            case 5: {
                frmPrefrencesEditor.showDialog(this);
                break;
            }
            case 37: {
                this.performWebCheck(true);
                break;
            }
            case 32: 
            case 33: {
                this.toggleResultSetDataView(this.getActiveTable(), true);
                break;
            }
            case 29: {
                iSQLAboutBox.showDialog(zParent);
                break;
            }
            case 18: {
                this.actionRefreshTableView();
                break;
            }
            case 6: {
                if (this.getActiveTable() == null) break;
                frmPrinterPreview.showPrintPreviewDialog(zParent, this.getActiveTable(), this.resultTabContainer.getSelectedToolTip());
                break;
            }
            case 12: {
                this.performTableExport();
                break;
            }
            case 27: {
                if (!this.isValidDatabaseConnection()) {
                    if (this.promptForService() != 1) {
                        return;
                    }
                    frmTableTools.showDialog(zParent, this.databaseConnection);
                    break;
                }
                frmTableTools.showDialog(zParent, this.databaseConnection);
                break;
            }
            case 2: {
                if (this.getActiveTable() != null) {
                    frmPrinterPreview.print(this.getActiveTable(), this.resultTabContainer.getSelectedToolTip());
                    break;
                }
                this.showInvalidConnection();
                break;
            }
            case 11: {
                this.performTableImport();
                break;
            }
            case 7: {
                frmBatchRunner.showDialog(zParent);
                break;
            }
            case 14: {
                this.toggleTransactionState();
                break;
            }
            case 1: {
                this.saveSQLHistory(true);
                break;
            }
            case 23: {
                this.performServiceChange(evt.getActionCommand());
                break;
            }
            case 0: {
                this.saveSQLHistory(false);
                break;
            }
            case 39: {
                File f = iSQLUtilites.getSystemFile(this);
                if (f == null) break;
                this.sqlCommandConsole.updateHistorySet(this.isqlConfig.getHistorySet(f), false);
                break;
            }
            case 24: 
            case 25: {
                this.toggleColumnDeleteAction(this.getActiveTable(), true);
                break;
            }
            case 30: {
                frmWarningViewer.showDialog(zParent);
                break;
            }
            case 16: {
                this.databaseConnection.performRollBack();
                break;
            }
            case 15: {
                this.databaseConnection.performCommit();
                break;
            }
            case 9: {
                this.exit();
                break;
            }
            case 8: {
                frmHistoryBrowser.showDialog(this);
                break;
            }
            case 3: {
                if (!this.isValidDatabaseConnection()) {
                    if (this.promptForService() != 1) {
                        return;
                    }
                    frmMetaExplorer.showDialog(this.databaseConnection);
                    break;
                }
                frmMetaExplorer.showDialog(this.databaseConnection);
                break;
            }
            case 19: {
                this.sqlCommandConsole.actionShowPreviousQuery();
                break;
            }
            case 20: {
                this.sqlCommandConsole.actionShowNextQuery();
                break;
            }
            case 21: {
                this.sqlCommandConsole.actionShowFirstQuery();
                break;
            }
            case 22: {
                this.sqlCommandConsole.actionShowLastQuery();
                break;
            }
            case 17: {
                if (isCtrlClick && isShiftClick) {
                    this.resultTabContainer.removeAllTabs();
                }
                this.performQuery(this.sqlCommandConsole.getText(), true);
                if (!this.isqlConfig.getBooleanProperty("General.AutoClear")) break;
                this.sqlCommandConsole.clear();
                break;
            }
        }
    }

    protected void exit() {
        zParent.dispatchEvent(new WindowEvent(zParent, 201));
    }

    public void performDisconnect() {
        if (this.databaseConnection == null) {
            this.InsertConsoleMessage(iSQLUtilites.getString("Not_Connected"));
            return;
        }
        if (!this.databaseConnection.isClosed()) {
            this.setStatus(iSQLUtilites.getString("Already_Disconnected"));
        } else {
            this.InsertConsoleMessage(iSQLUtilites.getString("Disconnect_Message", this.databaseConnection.getConnectionName()));
            this.currentStatus = iSQLUtilites.getString("Disconnected");
            try {
                if (this.isqlConfig.getBooleanProperty("General.UseDiscreteHistory")) {
                    if (this.isqlConfig.getBooleanProperty("General.History.Autoload")) {
                        this.saveCurrentHistory();
                    }
                    this.sqlCommandConsole.clearHistory();
                }
                String s = this.databaseConnection.getConnectionName();
                this.databaseConnection.disconnect();
                this.InsertConsoleMessage(iSQLUtilites.getString("Disconnect_Success", s));
                s = null;
            }
            catch (Throwable t) {
                iSQLUtilites.HandleException(t, iSQLUtilites.getString("Disconnect_Exception"));
            }
            this.databaseConnection = null;
            this.setStatus(this.currentStatus);
        }
    }

    protected synchronized JTable getActiveTable() {
        try {
            if (this.resultTabContainer.getTabCount() <= 0) {
                return null;
            }
            JScrollPane jsp = (JScrollPane)this.resultTabContainer.getSelectedComponent();
            return (JTable)jsp.getViewport().getView();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void performTableImport() {
        if (!this.isValidDatabaseConnection()) {
            if (this.promptForService() != 1) {
                return;
            }
            frmImportWizard wizard = new frmImportWizard((Frame)zParent, this.databaseConnection);
            wizard.show();
        } else {
            frmImportWizard wizard = new frmImportWizard((Frame)zParent, this.databaseConnection);
            wizard.show();
        }
    }

    protected void performTableExport() {
        if (this.getActiveTable() == null) {
            this.showInvalidConnection();
            return;
        }
        try {
            frmExportWizard wiz = new frmExportWizard((Frame)zParent, (ResultSetTableModel)this.getActiveTable().getModel());
            wiz.show();
        }
        catch (Throwable throwable) {}
    }

    protected void createFileToolBar() {
        if (!this.isqlConfig.getBooleanProperty("ToolBar.File.visible")) {
            return;
        }
        if (this.toolbarFile == null) {
            this.toolbarFile = new iSQLFileToolBar(this.actionManager);
            this.toolbarFile.setFloatable(true);
            String s = this.isqlConfig.getStringProperty("ToolBar.File.Dock");
            this.add((Component)this.toolbarFile, s);
            this.invalidate();
            if (s.equalsIgnoreCase("East") || s.equalsIgnoreCase("West")) {
                this.toolbarFile.setOrientation(1);
            }
        }
    }

    protected void removeFileToolBar() {
        if (this.toolbarFile != null) {
            try {
                this.remove(this.toolbarFile);
                this.toolbarFile.removeAll();
                this.invalidate();
            }
            catch (Exception exception) {}
            this.toolbarFile = null;
        }
    }

    protected void createResultSetToolBar() {
        if (!this.isqlConfig.getBooleanProperty("ToolBar.ResultSet.visible")) {
            return;
        }
        if (this.toolbarResultSet == null) {
            this.toolbarResultSet = new iSQLResultSetToolBar(this.actionManager);
            String s = this.isqlConfig.getStringProperty("ToolBar.ResultSet.Dock");
            this.panelResultSetContaier.add((Component)this.toolbarResultSet, s);
            if (s.equalsIgnoreCase("East") || s.equalsIgnoreCase("West")) {
                this.toolbarResultSet.setOrientation(1);
            } else {
                this.toolbarResultSet.setOrientation(0);
            }
            this.tabChangeHandler.stateChanged(new ChangeEvent(this.resultTabContainer));
        }
    }

    protected void removeResultSetControls() {
        if (this.toolbarResultSet != null) {
            try {
                this.panelResultSetContaier.remove(this.toolbarResultSet);
                this.toolbarResultSet.removeAll();
                this.invalidate();
            }
            catch (Exception exception) {}
            this.toolbarResultSet = null;
            System.runFinalization();
        }
    }

    protected void createHistoryControls() {
        this.sqlCommandConsole.addToolBar();
    }

    protected void removeHistoryControls() {
        this.sqlCommandConsole.removeToolBar();
    }

    protected void performServiceChange(String Service) {
        if (this.databaseConnection != null && this.databaseConnection.getConnectionName().equals(Service) && this.isValidDatabaseConnection()) {
            this.InsertConsoleMessage(iSQLUtilites.getString("Already_Connected_Message", Service));
            return;
        }
        try {
            this.actionManager.disableAction("16");
            this.actionManager.disableAction("15");
            try {
                if (this.isValidDatabaseConnection()) {
                    this.performDisconnect();
                }
                this.databaseConnection = null;
            }
            catch (Throwable throwable) {
                this.databaseConnection = null;
            }
            this.initJDBCTrace(this.isqlConfig.loadJDBCPropertiesForService(Service));
            this.databaseConnection = this.isqlConfig.getiSQLService(Service, true);
            if (this.isqlConfig.isConnectionPromptRequired(Service)) {
                String[] newTokens = AuthDialog.showDialog(zParent);
                if (newTokens == null) {
                    this.InsertConsoleMessage(iSQLUtilites.getString("Connect_Cancelled", Service));
                    this.databaseConnection = null;
                    return;
                }
                this.databaseConnection.updateAutheticationTokens(newTokens[0], newTokens[1]);
            }
            if (this.databaseConnection.init()) {
                this.InsertConsoleMessage(iSQLUtilites.getString("Connect_Sucess_Message", Service));
                this.currentStatus = iSQLUtilites.getString("Connect_Status", Service);
                this.setStatus(this.currentStatus);
                this.databaseConnection.setConnectionName(Service);
                if (this.isqlConfig.getBooleanProperty("General.UseDiscreteHistory") && this.isqlConfig.getBooleanProperty("General.History.Autoload")) {
                    this.sqlCommandConsole.updateHistorySet(this.isqlConfig.getLastHistorySet(this.databaseConnection), true);
                }
                try {
                    frmWarningViewer.addConnectionWarnings(this.databaseConnection.getConnectionWarnings());
                }
                catch (Throwable throwable) {}
            } else {
                JOptionPane.showMessageDialog(this, iSQLUtilites.getString("Connect_Failed", this.databaseConnection.getLastError().toString()), iSQLUtilites.getString("Error"), 0);
                this.databaseConnection = null;
            }
        }
        catch (Throwable t) {
            iSQLUtilites.HandleException(t, iSQLUtilites.getString("ServiceUpdate_Exception"), true);
            this.InsertConsoleMessage(iSQLUtilites.getString("Connect_Failed_Message", Service));
            this.databaseConnection = null;
        }
    }

    protected void performQuery(String command, boolean log2History) {
        try {
            StringBuffer stringBuffer = this.lastQuery;
            synchronized (stringBuffer) {
                this.lastQuery.setLength(0);
                this.lastQuery.append(command.trim());
            }
            if (log2History) {
                this.sqlCommandConsole.addHistoryElement(command);
            }
            if (!this.isValidDatabaseConnection()) {
                if (this.promptForService() != 1) {
                    this.InsertConsoleMessage(iSQLUtilites.getString("Invalid_Connection"));
                    this.currentStatus = iSQLUtilites.getString("Not_Connected");
                    this.setStatus(this.currentStatus);
                    return;
                }
            } else if (command.trim().length() == 0) {
                this.InsertConsoleMessage(iSQLUtilites.getString("Empty_SQL_Error"));
                return;
            }
        }
        catch (Exception ex) {
            iSQLUtilites.HandleException(ex);
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        try {
            this.databaseConnection.executeQuery(this.lastQuery.toString(), this);
        }
        catch (Throwable t) {
            this.setCursor(Cursor.getDefaultCursor());
            this.sqlCommandConsole.getTextComponent().requestFocus();
            this.refreshflag = false;
            iSQLUtilites.HandleException(t);
        }
        try {
            frmWarningViewer.addConnectionWarnings(this.databaseConnection.getConnectionWarnings());
        }
        catch (Throwable throwable) {}
    }

    protected JConsole getConsole() {
        return this.iSQLConsole;
    }

    public boolean isValidDatabaseConnection() {
        if (this.databaseConnection == null) {
            return false;
        }
        return this.databaseConnection.isClosed();
    }

    protected void initJDBCTrace(xProperties props) {
        if (!((Hashtable)this.isqlConfig).containsKey("General.Log.JDBC") && props.getBooleanProperty("JDBC.EnableTrace")) {
            DriverManager.setLogWriter(new PrintWriter(this.iSQLConsole.createFilteredStream("DriverManager"), true));
        } else if (((Hashtable)this.isqlConfig).containsKey("General.Log.JDBC") && props.getBooleanProperty("JDBC.EnableTrace")) {
            File f = new File(iSQLConfig.getiSQLSubDir("logs"), this.databaseConnection.getConnectionName());
            try {
                if (!f.exists()) {
                    f.createNewFile();
                }
                DriverManager.setLogWriter(new PrintWriter(new FileOutputStream(f.getName(), true)));
            }
            catch (IOException iOException) {
                DriverManager.setLogWriter(new PrintWriter(this.iSQLConsole.createFilteredStream("DriverManager"), true));
            }
        } else {
            DriverManager.setLogWriter(null);
        }
    }

    protected void initLogging() {
        System.setOut(new PrintStream(this.iSQLConsole.toOutputStream(), true));
        if (!((Hashtable)this.isqlConfig).containsKey("General.Log.System.err")) {
            System.setErr(new PrintStream(this.iSQLConsole.toOutputStream(), true));
        }
    }

    private void saveSQLHistory(File f, boolean verbose) {
        try {
            if (!f.exists()) {
                f.createNewFile();
            }
        }
        catch (Exception ioe) {
            iSQLUtilites.HandleException(ioe, iSQLUtilites.getString("Error_Writing_File", f.getAbsolutePath()));
            return;
        }
        try {
            this.sqlCommandConsole.save(new PrintWriter(new FileOutputStream(f), false));
            if (verbose) {
                this.InsertConsoleMessage(iSQLUtilites.getString("File_Saved", f.getAbsolutePath()));
            }
        }
        catch (Exception e) {
            iSQLUtilites.HandleException(e, iSQLUtilites.getString("Error_Writing_File", f.getAbsolutePath()));
            return;
        }
        f = null;
    }

    private synchronized void toggleTransactionState() {
        if (!this.isValidDatabaseConnection()) {
            this.InsertConsoleMessage(iSQLUtilites.getString("Invalid_Connection"));
            return;
        }
        boolean inTransactionMode = false;
        try {
            inTransactionMode = this.databaseConnection.getAutoCommit();
            this.databaseConnection.setAutoCommit(!inTransactionMode);
            this.lblAutoCommit.setText(" " + (inTransactionMode ? iSQLUtilites.getString("AutoCommit_OFF") : iSQLUtilites.getString("AutoCommit_ON")) + " ");
            this.lblAutoCommit.setMaximumSize(this.lblAutoCommit.getPreferredSize());
            this.lblAutoCommit.setMinimumSize(this.lblAutoCommit.getPreferredSize());
            this.panelStatusContainer.revalidate();
            if (inTransactionMode && !this.databaseConnection.isTransactionsSupported()) {
                this.InsertConsoleMessage(iSQLUtilites.getString("Transaction_Warning"));
            }
            if (inTransactionMode) {
                this.actionManager.enableAction("16");
                this.actionManager.enableAction("15");
            } else {
                this.actionManager.disableAction("16");
                this.actionManager.disableAction("15");
            }
        }
        catch (Exception e) {
            iSQLUtilites.HandleException(e, iSQLUtilites.getString("Transaction_Exception"));
            this.actionManager.disableAction("16");
            this.actionManager.disableAction("15");
            this.lblAutoCommit.setText(iSQLUtilites.getString("AutoCommit_ON"));
            return;
        }
    }

    private void showInvalidConnection() {
        JOptionPane.showMessageDialog(this, iSQLUtilites.getString("Connection_Nag"), iSQLUtilites.getString("Error"), 0);
    }

    private void updateServerList() {
        Object[] s = this.isqlConfig.getAvailableServices();
        this.mainMenuBar.refreshServiceMenu(s);
    }

    private synchronized void initUI() throws Exception {
        Border lBorder = BorderFactory.createBevelBorder(1);
        Insets ins = new Insets(0, 0, 0, 0);
        this.sqlCommandConsole = new iSQLCommandConsole();
        this.sqlCommandConsole.addCaretListener(this.textActionHandler);
        this.mConsolePopup.addJTextComponent(this.iSQLConsole);
        this.lblStatus.setBorder(lBorder);
        this.resultTabContainer.addChangeListener(this.tabChangeHandler);
        this.resultTabContainer.addActionListener(this.actionHandler);
        this.consoleTabContainer.addChangeListener(this.tabChangeHandler);
        this.iSQLConsole.getDocument().addDocumentListener(this.textActionHandler);
        this.consoleTabContainer.addTab("", iSQLUtilites.loadIconResource("Console16"), this.mConsoleScroller, iSQLUtilites.getString("Console_Tip"));
        this.consoleTabContainer.addTab("", iSQLUtilites.loadIconResource("ViewData16"), this.mDataInspector, iSQLUtilites.getString("Extended_View_Tip"));
        this.panelResultSetContaier.add((Component)this.resultTabContainer, "Center");
        this.mIOSplitPane.setTopComponent(this.sqlCommandConsole);
        this.mIOSplitPane.setBottomComponent(this.panelResultSetContaier);
        this.panelConsoleContainer.add((Component)this.consoleTabContainer, "Center");
        this.panelConsoleContainer.add((Component)this.panelStatusContainer, "South");
        this.mRootsplitPane.setOrientation(0);
        this.mRootsplitPane.setOneTouchExpandable(true);
        this.mRootsplitPane.setDoubleBuffered(true);
        this.lblCaretLocation.setBorder(lBorder);
        this.lblCaretLocation.setPreferredSize(this.lblCaretLocation.getPreferredSize());
        this.lblCaretLocation.setMaximumSize(this.lblCaretLocation.getPreferredSize());
        this.lblCaretLocation.setMinimumSize(this.lblCaretLocation.getPreferredSize());
        this.lblAutoCommit.setBorder(lBorder);
        this.lblAutoCommit.setMaximumSize(this.lblAutoCommit.getPreferredSize());
        this.lblAutoCommit.setMinimumSize(this.lblAutoCommit.getPreferredSize());
        this.panelStatusContainer.add((Component)this.lblStatus, new GridBagConstraints(0, 0, 1, 1, 0.9, 0.0, 18, 2, ins, 1, 1));
        this.panelStatusContainer.add((Component)this.lblAutoCommit, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 2, ins, 1, 1));
        this.panelStatusContainer.add((Component)this.lblCaretLocation, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 2, ins, 1, 1));
        this.setLayout(new BorderLayout());
        this.add((Component)this.mRootsplitPane, "Center");
        this.setStatus("");
    }

    private int promptForService() {
        Object s = JOptionPane.showInputDialog(this, iSQLUtilites.getString("Please_Select_Your_Service"), iSQLUtilites.getString("Service_Required"), 1, iSQLUtilites.loadIconResource("Database24"), this.isqlConfig.getAvailableServices(), null);
        if (s == null) {
            this.showInvalidConnection();
            return -1;
        }
        this.performServiceChange(s.toString());
        return this.isValidDatabaseConnection() ? 1 : -1;
    }

    private void updateConsoleIcon() {
        int i = this.consoleTabContainer.getSelectedIndex();
        if (i != 0 && !this.consoleTabContainer.getIconAt(0).equals(ICON_CONSOLE_LIGHT)) {
            this.consoleTabContainer.setIconAt(0, ICON_CONSOLE_LIGHT);
        }
    }

    private class TabChangeHandler
    implements ChangeListener {
        TabChangeHandler() {
        }

        public void stateChanged(ChangeEvent e) {
            Object src = e.getSource();
            if (src == frmiSQLMain.this.resultTabContainer) {
                try {
                    frmiSQLMain.this.toggleResultSetDataView(frmiSQLMain.this.getActiveTable(), false);
                    frmiSQLMain.this.toggleColumnDeleteAction(frmiSQLMain.this.getActiveTable(), false);
                    frmiSQLMain.this.toggleLockAction(frmiSQLMain.this.resultTabContainer.getSelectedIndex(), false);
                }
                catch (Exception exception) {}
            }
            if (src == frmiSQLMain.this.consoleTabContainer) {
                frmiSQLMain.this.consoleTabContainer.setIconAt(0, ICON_CONSOLE_DARK);
            }
        }
    }

    public class TextActionHandler
    implements CaretListener,
    DocumentListener {
        public void insertUpdate(DocumentEvent parm1) {
            frmiSQLMain.this.updateConsoleIcon();
        }

        public void removeUpdate(DocumentEvent parm1) {
            frmiSQLMain.this.updateConsoleIcon();
        }

        public void changedUpdate(DocumentEvent parm1) {
            frmiSQLMain.this.updateConsoleIcon();
        }

        public void caretUpdate(CaretEvent e) {
            try {
                frmiSQLMain.this.lblCaretLocation.setText(String.valueOf(frmiSQLMain.this.sqlCommandConsole.getCaretRow(e.getDot())) + ":" + frmiSQLMain.this.sqlCommandConsole.getCaretCol(e.getDot()));
            }
            catch (Exception exception) {}
        }
    }

    public class ActionManagerHandler
    implements ItemListener,
    ActionListener,
    PropertyChangeListener {
        public void itemStateChanged(ItemEvent e) {
            JCheckBoxAction chkBox = (JCheckBoxAction)e.getItem();
            String actionName = chkBox.getValue("Name").toString();
            if (actionName.equalsIgnoreCase(iSQLUtilites.getString("History_Toolbar"))) {
                frmiSQLMain.this.isqlConfig.setBooleanProperty("ToolBar.History.visible", chkBox.isSelected());
                if (chkBox.isSelected()) {
                    frmiSQLMain.this.createHistoryControls();
                } else {
                    frmiSQLMain.this.removeHistoryControls();
                }
            } else if (actionName.equalsIgnoreCase(iSQLUtilites.getString("File_Toolbar"))) {
                frmiSQLMain.this.isqlConfig.setBooleanProperty("ToolBar.File.visible", chkBox.isSelected());
                if (chkBox.isSelected()) {
                    frmiSQLMain.this.createFileToolBar();
                } else {
                    frmiSQLMain.this.removeFileToolBar();
                }
            } else if (actionName.equalsIgnoreCase(iSQLUtilites.getString("Resultset_Toolbar"))) {
                frmiSQLMain.this.isqlConfig.setBooleanProperty("ToolBar.ResultSet.visible", chkBox.isSelected());
                if (chkBox.isSelected()) {
                    frmiSQLMain.this.createResultSetToolBar();
                } else {
                    frmiSQLMain.this.removeResultSetControls();
                }
            }
            frmiSQLMain.this.invalidate();
            zParent.validate();
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (propName.equals("begin-command")) {
                String value = (String)evt.getNewValue();
                frmiSQLMain.this.setStatus(value);
            } else if (propName.equals("end-command")) {
                frmiSQLMain.this.setStatus(frmiSQLMain.this.currentStatus);
            }
        }

        public void actionPerformed(ActionEvent e) {
            zParent.setCursor(Cursor.getPredefinedCursor(3));
            try {
                try {
                    frmiSQLMain.this.handleActionEvent(e);
                }
                catch (Exception ex) {
                    iSQLUtilites.HandleException(ex, null, true);
                }
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                zParent.setCursor(Cursor.getPredefinedCursor(0));
                throw throwable;
            }
            Object var3_5 = null;
            zParent.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

