/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableCellRenderer;
import org.I00acres.isql.forms.frmPrinterPreview;
import org.I00acres.isql.swing.SortableHeaderRenderer;
import org.I00acres.isql.swing.table.iSQLTableModel;
import org.I00acres.isql.util.iSQLUtilites;

public final class iSQLAboutBox
extends JDialog {
    private JLabel logoLabel = new JLabel(iSQLUtilites.loadIconResource("splash_logo"), 0);
    private JLabel resourceLabel = new JLabel("", 0);
    private JLabel URLLabel = new JLabel(iSQLUtilites.getString("Homepage_Label", "http://isql.sourceforge.net"), 0);
    private JPanel infoPanel = new JPanel(new GridBagLayout());
    private JTable systemProperties = new JTable(new iSQLTableModel(System.getProperties()));
    private JButton printButton = new JButton(iSQLUtilites.loadIconResource("Print16"));
    private JButton btnOK = new JButton(iSQLUtilites.getString("Ok"));
    private JTabbedPane tabContainer = new JTabbedPane();
    private JEditorPane creditText = new JEditorPane("text/html", "<html></html>");
    private JProgressBar resourceMeter = new JProgressBar();
    private ResourceMonitor resourceMonitor = new ResourceMonitor();
    private Thread resourceThread = new Thread((Runnable)this.resourceMonitor, "iSQL-Viewer-ResourceMonitor");
    private ActionListener actionHandler = new ActionHandler();
    static /* synthetic */ Class class$0;

    public static void showDialog(Frame Owner) {
        iSQLAboutBox box = new iSQLAboutBox(Owner);
        box.show();
        box = null;
    }

    private iSQLAboutBox(Frame parent) {
        super(parent, "", true);
        this.enableEvents(64L);
        try {
            this.initUI();
            this.resourceThread.start();
        }
        catch (Throwable t) {
            iSQLUtilites.HandleException(t, "iSQLAboutBox::initUI()");
        }
        this.pack();
        ((Component)this).setSize(new Dimension(512, 348));
        this.setLocationRelativeTo(parent);
    }

    private void initUI() throws Exception {
        Insets ins = new Insets(1, 1, 1, 1);
        JScrollPane jsp = new JScrollPane(this.systemProperties);
        jsp.setCorner("UPPER_RIGHT_CORNER", this.printButton);
        this.printButton.setToolTipText(iSQLUtilites.getString("Print_System_Properties"));
        this.printButton.addActionListener(this.actionHandler);
        this.btnOK.addActionListener(this.actionHandler);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.systemProperties.setDefaultRenderer(clazz, new PropertyRenderer());
        this.setTitle(String.valueOf(iSQLUtilites.getString("About_Tab_Label")) + " iSQL-Viewer " + iSQLUtilites.getString("Version") + " " + "2.1.0");
        this.infoPanel.add((Component)new JLabel(String.valueOf(iSQLUtilites.getString("Product")) + " :"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.infoPanel.add((Component)new JLabel("iSQL-Viewer"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.infoPanel.add((Component)new JLabel(String.valueOf(iSQLUtilites.getString("Version")) + " :"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.infoPanel.add((Component)new JLabel("2.1.0"), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.infoPanel.add((Component)this.resourceMeter, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 2, ins, 0, 0));
        this.infoPanel.add((Component)this.resourceLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, ins, 0, 0));
        this.infoPanel.add((Component)new JLabel(iSQLUtilites.getString("System_Properties"), 0), new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 2, ins, 0, 0));
        this.infoPanel.add((Component)jsp, new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 10, 1, ins, 0, 0));
        this.infoPanel.add((Component)this.URLLabel, new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 10, 0, ins, 0, 0));
        try {
            this.creditText.setEditable(false);
            this.creditText.setPage(iSQLUtilites.getResourceURL("html/credits.html"));
        }
        catch (Exception exception) {}
        iSQLUtilites.lockComponentToPerferredSize(this.resourceLabel);
        this.logoLabel.setBorder(BorderFactory.createBevelBorder(1));
        JPanel pnel = new JPanel(new BorderLayout());
        Color c = Color.decode("#9999CC");
        pnel.setBackground(c);
        pnel.setForeground(c);
        pnel.add((Component)this.logoLabel, "Center");
        iSQLUtilites.lockComponentToPerferredSize(pnel);
        this.btnOK.setPreferredSize(new Dimension(2 * this.btnOK.getPreferredSize().width, this.btnOK.getPreferredSize().height));
        iSQLUtilites.lockComponentToPerferredSize(this.btnOK);
        iSQLUtilites.TableMouseAdapter ml = new iSQLUtilites.TableMouseAdapter(this.actionHandler);
        this.systemProperties.addMouseListener(ml);
        this.systemProperties.getTableHeader().addMouseListener(ml);
        this.systemProperties.getTableHeader().setDefaultRenderer(new SortableHeaderRenderer(this.systemProperties));
        JToolBar tb = new JToolBar(0);
        tb.setFloatable(false);
        tb.add(Box.createHorizontalGlue());
        tb.add(this.btnOK);
        this.getContentPane().add((Component)tb, "South");
        this.getContentPane().add((Component)this.tabContainer, "Center");
        this.tabContainer.addTab(iSQLUtilites.getString("About_Tab_Label"), pnel);
        this.tabContainer.addTab(iSQLUtilites.getString("Info_Tab_Label"), this.infoPanel);
        this.tabContainer.addTab(iSQLUtilites.getString("Credit_Tab_Label"), new JScrollPane(this.creditText));
        this.resourceMeter.setStringPainted(true);
        this.resourceMeter.setToolTipText(iSQLUtilites.getString("Resource_Meter_Tip"));
        this.setResizable(false);
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel();
        }
        super.processWindowEvent(e);
    }

    private synchronized void cancel() {
        this.resourceMonitor.halt();
        try {
            this.resourceThread.join(3000L);
        }
        catch (Throwable throwable) {}
        System.runFinalization();
    }

    private class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == iSQLAboutBox.this.printButton) {
                frmPrinterPreview.showPrintPreviewDialog((Frame)iSQLAboutBox.this.getParent(), iSQLAboutBox.this.systemProperties, iSQLUtilites.getString("System_Properties"));
            } else if (e.getSource() == iSQLAboutBox.this.btnOK) {
                iSQLAboutBox.this.dispose();
            }
        }
    }

    private class PropertyRenderer
    extends DefaultTableCellRenderer {
        Font fnt = new Font("Lucinda Sans", 1, 12);

        PropertyRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelection, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelection, hasFocus, row, column);
            if (column == 0 && ((String)value).startsWith("isql.")) {
                this.setFont(this.fnt);
            } else if (column == 1 && ((String)table.getValueAt(row, 0)).startsWith("isql.")) {
                this.setFont(this.fnt);
            }
            return this;
        }
    }

    private class ResourceMonitor
    implements Runnable {
        final double MB = Math.pow(2.0, 20.0);
        final Runtime rt = Runtime.getRuntime();
        boolean stop = false;
        String[] strs = new String[2];
        NumberFormat Nf = NumberFormat.getNumberInstance();

        public ResourceMonitor() {
            this.Nf.setMaximumFractionDigits(2);
            this.Nf.setMinimumFractionDigits(2);
            this.Nf.setMaximumIntegerDigits(8);
            this.strs[1] = iSQLUtilites.getString("MegaByte");
        }

        private synchronized void halt() {
            ResourceMonitor resourceMonitor = this;
            synchronized (resourceMonitor) {
                this.stop = true;
                this.notify();
            }
        }

        public void run() {
            while (!this.stop) {
                try {
                    long UsedMemory = this.rt.totalMemory() - this.rt.freeMemory();
                    if (iSQLAboutBox.this.resourceMeter.getMaximum() != (int)this.rt.totalMemory()) {
                        iSQLAboutBox.this.resourceMeter.setMaximum((int)this.rt.totalMemory());
                    }
                    if (iSQLAboutBox.this.resourceMeter.getValue() != (int)UsedMemory) {
                        iSQLAboutBox.this.resourceMeter.setValue((int)UsedMemory);
                        this.strs[0] = this.Nf.format((double)this.rt.totalMemory() / this.MB);
                        iSQLAboutBox.this.resourceMeter.setString(String.valueOf(this.Nf.format((double)UsedMemory / this.MB)) + " " + this.strs[1]);
                        iSQLAboutBox.this.resourceLabel.setText(iSQLUtilites.getString("Resource_Label", this.strs));
                        System.runFinalization();
                    }
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {}
            }
        }
    }
}

