/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.I00acres.isql.forms.frmiSQLMain;
import org.I00acres.isql.swing.action.iSQLActionManager;
import org.I00acres.isql.swing.iSQLMenuBar;
import org.I00acres.isql.util.iSQLConfig;
import org.I00acres.isql.util.iSQLUtilites;

public class iSQLFrame
extends JFrame {
    private final iSQLConfig config = iSQLConfig.getInstance();
    private iSQLActionManager mActionManager;
    private Thread actionThread;
    private iSQLMenuBar mJMenuBar;
    private frmiSQLMain panel;

    public iSQLFrame() {
        this.enableEvents(72L);
        this.setDefaultCloseOperation(3);
        try {
            this.mActionManager = new iSQLActionManager(this.config.getBooleanProperty("General.ShowSplash"));
            this.mJMenuBar = new iSQLMenuBar(this.mActionManager);
            this.initUI();
        }
        catch (Throwable t) {
            iSQLUtilites.HandleException(t, "iSQLFrame::iSQLFrame()", true);
            System.exit(-1);
        }
        this.actionThread = new Thread((Runnable)this.mActionManager, "Action-Manager Thread");
        this.actionThread.setDaemon(true);
        this.actionThread.start();
        if (this.config.getBooleanProperty("Advanced.AutoVersionCheck")) {
            this.panel.performWebCheck(false);
        }
    }

    private synchronized void initUI() throws Exception {
        this.setDefaultCloseOperation(2);
        this.setTitle("iSQL-Viewer v2.1.0");
        this.setJMenuBar(this.mJMenuBar);
        this.panel = new frmiSQLMain(this);
        this.panel.setActionManager(this.mActionManager);
        this.panel.setJMenuBar(this.mJMenuBar);
        this.getContentPane().add((Component)this.panel, "Center");
        this.mJMenuBar.setTextComponent(this.panel.getDefaultTextComponent());
        ((Component)this).setSize(640, 480);
        try {
            ((Frame)this).setIconImage(((ImageIcon)iSQLUtilites.loadIconResource("Database24")).getImage());
        }
        catch (Exception exception) {}
        if (((Hashtable)this.config).containsKey("General.LastX") && ((Hashtable)this.config).containsKey("General.LastY") && ((Hashtable)this.config).containsKey("General.LastW") && ((Hashtable)this.config).containsKey("General.LastH") && this.config.getBooleanProperty("General.UseLastGeometry")) {
            ((Component)this).setSize(new Dimension(this.config.getIntProperty("General.LastW"), this.config.getIntProperty("General.LastH")));
            ((Component)this).setLocation(this.config.getIntProperty("General.LastX"), this.config.getIntProperty("General.LastY"));
        } else {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = this.getSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            ((Component)this).setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        }
        this.validate();
        this.show();
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            try {
                Thread.yield();
            }
            catch (Exception exception) {}
            this.config.getBooleanProperty("General.History.Autoload");
            this.panel.saveCurrentHistory();
            if (this.config.getBooleanProperty("General.UseLastGeometry")) {
                iSQLFrame iSQLFrame2 = this;
                synchronized (iSQLFrame2) {
                    this.config.setIntProperty("General.LastX", this.getLocationOnScreen().x);
                    this.config.setIntProperty("General.LastY", this.getLocationOnScreen().y);
                    this.config.setIntProperty("General.LastW", this.getSize().width);
                    this.config.setIntProperty("General.LastH", this.getSize().height);
                }
            } else {
                this.config.removeProperty("General.LastX");
                this.config.removeProperty("General.LastY");
                this.config.removeProperty("General.LastW");
                this.config.removeProperty("General.LastH");
            }
            if (this.panel.isValidDatabaseConnection()) {
                this.panel.performDisconnect();
            }
            this.mActionManager = null;
            this.mJMenuBar = null;
            this.panel = null;
            System.runFinalization();
            this.config.save();
            System.exit(1);
        } else if (e.getID() == 205) {
            this.panel.setDefaultFocus();
        }
    }
}

