/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.I00acres.isql.swing.JTextComponentPopup;
import org.I00acres.isql.util.iSQLConfig;
import org.I00acres.isql.util.iSQLUtilites;
import org.I00acres.lib.sql.DatabaseConnection;

public abstract class AbstractTableTool
extends JPanel {
    private JTextArea sqlText = null;
    private JSplitPane toolRoot = null;
    private JPanel toolContainer = null;
    private JScrollPane toolScrollPane = null;
    private boolean createsSQL = true;
    private transient Vector changeListeners;
    protected static final JTextComponentPopup textPopup = new JTextComponentPopup();
    protected DatabaseConnection databaseConnection;
    protected final iSQLConfig isqlConfig = iSQLConfig.getInstance();

    protected AbstractTableTool() {
        this(true);
    }

    protected AbstractTableTool(boolean generatesSQL) {
        super(new BorderLayout());
        this.createsSQL = generatesSQL;
        if (generatesSQL) {
            try {
                this.sqlText = new JTextArea("");
                this.toolRoot = new JSplitPane(0, true);
                this.toolContainer = new JPanel();
                this.toolScrollPane = new JScrollPane(this.toolContainer);
                JScrollPane jsp = new JScrollPane(this.sqlText);
                this.toolRoot = new JSplitPane(0, true);
                this.toolRoot.setTopComponent(this.toolScrollPane);
                this.toolRoot.setBottomComponent(jsp);
                super.add((Component)this.toolRoot, "Center");
                jsp.setColumnHeaderView(new JLabel(iSQLUtilites.getString("SQL_TEXT_LBL")));
                this.sqlText.setEditable(false);
                this.sqlText.setLineWrap(true);
                this.sqlText.setWrapStyleWord(true);
                textPopup.addJTextComponent(this.sqlText);
            }
            catch (Throwable throwable) {}
        }
    }

    public final void updateConnection(DatabaseConnection db) {
        if (db == null) {
            this.databaseConnection = null;
            this.connectionUpdated();
            return;
        }
        boolean isNewConnection = this.databaseConnection == null || !db.equals(this.databaseConnection);
        this.databaseConnection = db;
        if (isNewConnection) {
            this.connectionUpdated();
        }
    }

    protected void connectionUpdated() {
    }

    public void execute() {
        if (this.databaseConnection != null) {
            try {
                this.synch();
                int result = this.databaseConnection.executeUpdate(this.getSQL());
                JOptionPane.showMessageDialog(this, iSQLUtilites.getString("Table_Tool_Exec_Success", "" + result));
            }
            catch (Throwable t) {
                JOptionPane.showMessageDialog(this, iSQLUtilites.getString("Table_Tool_Exec_Failed", t.getMessage()), "", 0);
            }
        }
    }

    public void reset() {
        try {
            this.setToolEnabled(true);
        }
        catch (Throwable throwable) {}
    }

    public final void edit() {
        this.sqlText.setEditable(true);
        this.toolScrollPane.setEnabled(false);
        this.setToolEnabled(false);
        this.sqlText.requestFocus();
        this.sqlText.selectAll();
    }

    protected void setToolEnabled(boolean f) {
    }

    public JTextComponent getTextComponent() {
        return this.sqlText;
    }

    public final void synch() {
        try {
            this.updateSQL(this.getSQL());
        }
        catch (Throwable throwable) {
            this.updateSQL("");
        }
    }

    protected final void updateSQL(String sql) {
        this.sqlText.setText(sql);
    }

    public Icon toIcon() {
        return iSQLUtilites.loadIconResource("Table16");
    }

    public void pack() {
        this.toolRoot.setDividerLocation(0.75);
    }

    public abstract String getToolName();

    public abstract boolean validateTool();

    protected abstract String getSQL();

    public final void setLayout(LayoutManager lm) {
        if (this.toolContainer != null) {
            this.toolContainer.setLayout(lm);
        } else {
            super.setLayout(lm);
        }
    }

    public final boolean generatesSQL() {
        return this.createsSQL;
    }

    public final void remove(int index) {
        this.toolContainer.remove(index);
    }

    public final void remove(Component c) {
        this.toolContainer.remove(c);
    }

    public final void add(Component c, Object constraints, int index) {
        if (this.createsSQL) {
            this.toolContainer.add(c, constraints, index);
        } else {
            super.add(c, constraints, index);
        }
    }

    public final Component add(Component c, int index) {
        if (this.createsSQL) {
            return this.toolContainer.add(c, index);
        }
        return super.add(c, index);
    }

    public final Component add(Component c) {
        if (this.createsSQL) {
            return this.toolContainer.add(c);
        }
        return super.add(c);
    }

    public final void add(Component c, Object constraints) {
        if (this.createsSQL) {
            this.toolContainer.add(c, constraints);
        } else {
            super.add(c, constraints);
        }
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        if (this.changeListeners != null && this.changeListeners.contains(l)) {
            Vector v = (Vector)this.changeListeners.clone();
            v.removeElement(l);
            this.changeListeners = v;
        }
    }

    public synchronized void addChangeListener(ChangeListener l) {
        Vector v;
        Vector vector = v = this.changeListeners == null ? new Vector(2) : (Vector)this.changeListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.changeListeners = v;
        }
    }

    protected void fireStateChanged(ChangeEvent e) {
        if (this.changeListeners != null) {
            Vector listeners = this.changeListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                ((ChangeListener)listeners.elementAt(i)).stateChanged(e);
                ++i;
            }
        }
    }
}

