/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.I00acres.isql.swing.table.DriverPropertyTableModel;
import org.I00acres.isql.util.ExtensionFactory;
import org.I00acres.isql.util.TableFilter;

public final class FilterEditor
extends JSplitPane
implements ListCellRenderer,
ListSelectionListener {
    private static ExtensionFactory factory = ExtensionFactory.getInstance();
    public static final int FILTER_IMPORT = 0;
    public static final int FILTER_EXPORT = 1;
    private DriverPropertyTableModel mFilterProperties = new DriverPropertyTableModel();
    private final JLabel CellRenderer = new JLabel();
    private Object filterDataType = new Object();
    private int type = 1;
    private DefaultListModel filterListModel = new DefaultListModel();
    private JList mFilterList = new JList(this.filterListModel);
    private JTable mPropertyTable = new JTable();
    private JTextArea mPropertyDescription = new JTextArea();
    private JSplitPane mTableSplit = new JSplitPane(0, true);
    private JScrollPane mTableContainer = new JScrollPane(this.mPropertyTable);
    private JScrollPane mTreeContainer = new JScrollPane(this.mFilterList);
    private JScrollPane mDescContainer = new JScrollPane(this.mPropertyDescription);
    private TableFilter mCurrentFilter;
    static /* synthetic */ Class class$0;

    public FilterEditor(int filter) {
        super(1, true);
        try {
            this.type = filter;
            this.initUI();
            this.loadFilters();
            this.setPreferredSize(new Dimension(512, 348));
            this.mFilterList.setSelectedIndex(0);
        }
        catch (Throwable throwable) {}
    }

    private void loadFilters() {
        this.filterListModel.clear();
        TableFilter[] filters = factory.getTableFilters();
        int i = 0;
        while (i < filters.length) {
            if (this.type == 1 && filters[i].isExportable() && filters[i].canFilterObject(this.filterDataType)) {
                this.filterListModel.addElement(filters[i]);
            } else if (this.type == 0 && filters[i].isImportable()) {
                this.filterListModel.addElement(filters[i]);
            }
            ++i;
        }
    }

    public void setSelectedFilterIndex(int index) {
        this.mFilterList.setSelectedIndex(index);
        this.changeFilter(index);
    }

    public int getSelectedFilterIndex() {
        return this.mFilterList.getSelectedIndex();
    }

    private void initUI() {
        this.CellRenderer.setFont(new Font("Luncinda Sans", 1, 12));
        this.CellRenderer.setForeground(Color.black);
        this.CellRenderer.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.mPropertyTable.setModel(this.mFilterProperties);
        this.mPropertyTable.setSelectionMode(0);
        this.mPropertyTable.getSelectionModel().addListSelectionListener(this);
        this.mPropertyTable.setAutoResizeMode(2);
        this.mPropertyDescription.setRows(3);
        this.mPropertyDescription.setEditable(false);
        this.mPropertyDescription.setEnabled(false);
        this.mPropertyDescription.setLineWrap(true);
        this.mPropertyDescription.setWrapStyleWord(true);
        this.mPropertyDescription.setDisabledTextColor(Color.black);
        this.mFilterList.setCellRenderer(this);
        this.mFilterList.addListSelectionListener(this);
        this.mPropertyTable.getSelectionModel().addListSelectionListener(this);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Ljava.lang.String;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.mPropertyTable.setDefaultEditor(clazz, this.mFilterProperties.getChoiceEditor());
        this.mFilterProperties.setToolTipsEnabled(false);
        this.mTableSplit.setTopComponent(this.mTableContainer);
        this.mTableSplit.setBottomComponent(this.mDescContainer);
        this.setLeftComponent(this.mTreeContainer);
        this.setRightComponent(this.mTableSplit);
    }

    public TableFilter getCurrentFilter() {
        return this.getCurrentFilter(false);
    }

    public void setFilterContent(Object cxt) {
        this.filterDataType = cxt;
        this.loadFilters();
    }

    public TableFilter getCurrentFilter(boolean set) {
        if (set && this.mCurrentFilter != null) {
            this.mPropertyTable.editingCanceled(new ChangeEvent(this.mPropertyTable));
            this.mCurrentFilter.configure(this.mFilterProperties.getTableAsProperties());
        }
        return this.mCurrentFilter;
    }

    public Component getListCellRendererComponent(JList list, Object value, int row, boolean hasFocus, boolean isSelected) {
        try {
            if (value instanceof TableFilter) {
                TableFilter filter = (TableFilter)value;
                this.CellRenderer.setText(filter.getName());
                this.CellRenderer.setIcon(filter.getUserIcon());
            } else {
                this.CellRenderer.setIcon(null);
                this.CellRenderer.setText(value == null ? "null" : value.toString());
            }
        }
        catch (Exception exception) {}
        this.CellRenderer.setOpaque(isSelected);
        return this.CellRenderer;
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.mFilterList) {
            this.changeFilter(this.mFilterList.getSelectedIndex());
        } else {
            int row = this.mPropertyTable.getSelectedRow();
            if (row >= 0) {
                this.mPropertyDescription.setText(this.mFilterProperties.getPropertyInfo((int)row).description);
            } else {
                this.mPropertyDescription.setText("");
            }
        }
    }

    public synchronized void validateFilter() {
        if (this.mCurrentFilter != null) {
            this.mCurrentFilter.configure(this.mFilterProperties.getTableAsProperties());
        }
    }

    private void changeFilter(int row) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.validateFilter();
            this.mCurrentFilter = (TableFilter)this.filterListModel.get(row);
            this.mPropertyTable.clearSelection();
            this.mPropertyTable.setEnabled(true);
            if (this.type == 1) {
                this.mFilterProperties.setData(this.mCurrentFilter.getExportProperties());
            } else if (this.type == 0) {
                this.mFilterProperties.setData(this.mCurrentFilter.getImportProperties());
            }
            this.mFilterProperties.setProperties(this.mCurrentFilter.getConfiguration());
            this.setDividerLocation(this.mFilterList.getPreferredSize().width + this.getDividerSize());
            this.mTableSplit.setDividerLocation(0.75);
            this.mTableSplit.invalidate();
            this.mTableContainer.invalidate();
            this.mPropertyTable.invalidate();
            this.validateTree();
        }
        catch (Throwable throwable) {}
        this.setCursor(Cursor.getPredefinedCursor(0));
    }
}

