/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.util;

import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.I00acres.isql.util.ExtensionFactory;
import org.I00acres.isql.util.iSQLUtilites;
import org.I00acres.lib.sql.DatabaseConnection;
import org.I00acres.lib.util.StringTokenizer;
import org.I00acres.lib.util.xProperties;

public final class iSQLConfig
extends xProperties {
    public static final int VERSION_MAJOR = 2;
    public static final int VERSION_MINOR = 1;
    public static final int VERSION_BUILD = 0;
    public static final String ISQL_VERSION = "2.1.0";
    private static File baseDirectory = new File(System.getProperty("isql.home", String.valueOf(System.getProperty("user.home")) + File.separator + ".iSQL-Viewer"));
    private static File autoClassPathDirectory = new File(System.getProperty("isql.classpath", iSQLConfig.getiSQLSubDir("lib").getAbsolutePath()));
    private static final String fPrefrences = "iSQL-Viewer.properties";
    private static final String fDriverDefs = "driver.properties";
    private ClassLoader xtraClassLoader = null;
    private static final byte[] xorKey = new byte[]{1, 8, 16, 24, 2, 10, 18, 26, 4, 12, 20, 28, 6, 14, 22, 30, 8, 16, 24, 32, 10, 18, 26, 34};
    private static final iSQLConfig instance = new iSQLConfig();
    private boolean URLsLoaded = false;
    private boolean containsEncPasswords = false;
    static /* synthetic */ Class class$0;

    public static synchronized File getBaseDirectory() {
        File file = baseDirectory;
        synchronized (file) {
            return baseDirectory;
        }
    }

    public static File getiSQLSubDir(String sub) {
        File f = new File(baseDirectory, sub);
        if (!f.exists()) {
            f.mkdirs();
        }
        return f;
    }

    public static final synchronized iSQLConfig getInstance() {
        return instance;
    }

    private iSQLConfig() {
        super(iSQLConfig.getDefaults());
        System.setProperty("isql.home", iSQLConfig.getBaseDirectory().getAbsolutePath());
        System.setProperty("isql.classpath", autoClassPathDirectory.getAbsolutePath());
        System.setProperty("isql.version", ISQL_VERSION);
        this.load();
        this.containsEncPasswords = !this.getBooleanProperty("General.StorePlainTextPassword");
    }

    public synchronized void save() {
        iSQLConfig iSQLConfig2 = this;
        synchronized (iSQLConfig2) {
            try {
                this.optimize();
                this.containsEncPasswords = !this.getBooleanProperty("General.StorePlainTextPassword");
                FileOutputStream fos = new FileOutputStream(new File(baseDirectory, fPrefrences));
                this.store(fos, "iSQL-Viewer v2.1.0 Properties File");
                fos.close();
            }
            catch (IOException ioe) {
                iSQLUtilites.HandleException(ioe, iSQLUtilites.getString("CFG_SAVE_ERROR"), true);
            }
        }
    }

    public boolean isConnectionPromptRequired(String Service) {
        return this.getBooleanProperty("Server." + Service + ".prompt", false);
    }

    public DatabaseConnection getiSQLService(String Service, boolean logDriverInfo) throws Exception {
        DatabaseConnection returns = null;
        boolean decrypt = !this.getBooleanProperty("General.StorePlainTextPassword");
        boolean configure = this.getBooleanProperty("Server." + Service + ".useDiscreteConfig", false);
        returns = this.getBooleanProperty("Server." + Service + ".useExt", false) ? new DatabaseConnection(this.getProperty("Server." + Service + ".url", ""), this.getProperty("Server." + Service + ".driver", ""), this.loadXtendedPropertiesForService(Service)) : new DatabaseConnection(this.getProperty("Server." + Service + ".url", ""), this.getProperty("Server." + Service + ".user", ""), decrypt ? this.decryptString(this.getStringProperty("Server." + Service + ".pass", "")) : this.getStringProperty("Server." + Service + ".pass", ""), this.getProperty("Server." + Service + ".driver", ""));
        iSQLUtilites.configureDatabaseConnection(configure ? this.loadJDBCPropertiesForService(Service) : this);
        if (logDriverInfo) {
            returns.logDriverInformation();
        }
        return returns;
    }

    public String[] getAvailableServices() {
        String Srv = this.getStringProperty("ServerList");
        StringTokenizer st = new StringTokenizer(Srv, ",", false);
        String[] servers = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            servers[i++] = st.nextToken();
        }
        return servers;
    }

    public File[] getXtraClassPaths() {
        String Srv = this.getStringProperty("Advanced.XtraClassPaths");
        StringTokenizer st = new StringTokenizer(Srv, System.getProperty("path.separator"), false);
        File[] servers = new File[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            servers[i++] = new File(st.nextToken());
        }
        return servers;
    }

    public Properties getDriverDefinitions() {
        File fdDrivers = new File(baseDirectory, fDriverDefs);
        if (fdDrivers.exists()) {
            try {
                Properties props = new Properties();
                props.load(new FileInputStream(fdDrivers));
                return props;
            }
            catch (IOException iOException) {}
        }
        fdDrivers = null;
        return null;
    }

    public void saveXtendedPropertiesForService(Properties props, String service) {
        File xFile = new File(iSQLConfig.getiSQLSubDir("ext"), service.replace(' ', '_'));
        try {
            if (!xFile.exists()) {
                xFile.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(xFile.getAbsolutePath(), false);
            props.store(fos, "Extended JDBC Properties For Service " + service);
            fos.close();
            xFile = null;
            fos = null;
        }
        catch (IOException ioe) {
            iSQLUtilites.HandleException(ioe, iSQLUtilites.getString("Error_Writing_File", xFile.getAbsolutePath()), true);
        }
    }

    public void saveJDBCPropertiesForService(Properties props, String service) {
        File xFile = new File(iSQLConfig.getiSQLSubDir("ext"), service.replace(' ', '_').concat(".jdbc.properties"));
        try {
            if (!xFile.exists()) {
                xFile.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(xFile.getAbsolutePath(), false);
            props.store(fos, "Extended JDBC Properties For Service " + service);
            fos.close();
            xFile = null;
            fos = null;
        }
        catch (IOException ioe) {
            iSQLUtilites.HandleException(ioe, iSQLUtilites.getString("Error_Writing_File", xFile.getAbsolutePath()), true);
        }
    }

    public ClassLoader getXtraClassLoader() {
        return this.getXtraClassLoader(false);
    }

    public ClassLoader getXtraClassLoader(boolean reload) {
        if (reload || this.xtraClassLoader == null) {
            this.initXtraClassPaths();
        }
        return this.xtraClassLoader;
    }

    private void initXtraClassPaths() {
        try {
            Object[] xtraPaths = new Object[]{ExtensionFactory.getExtensions(), this.getXtraClassPaths(), autoClassPathDirectory.listFiles()};
            Vector<URL> urls = new Vector<URL>();
            int i = 0;
            while (i < xtraPaths.length) {
                File[] set = (File[])xtraPaths[i];
                int j = 0;
                while (j < set.length) {
                    if (set[j].getName().endsWith(".jar") || set[j].getName().endsWith(".zip")) {
                        try {
                            urls.add(set[j].toURL());
                        }
                        catch (Throwable throwable) {}
                    }
                    ++j;
                }
                ++i;
            }
            if (!urls.isEmpty()) {
                URL[] xClassPath = urls.toArray(new URL[urls.size()]);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.I00acres.isql.util.iSQLConfig");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.xtraClassLoader = new URLClassLoader(xClassPath, clazz.getClassLoader());
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.I00acres.isql.util.iSQLConfig");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.xtraClassLoader = clazz.getClassLoader();
            }
            ExtensionFactory.updateClassLoader(this.xtraClassLoader);
            UIManager.put("ClassLoader", this.xtraClassLoader);
            Thread.currentThread().setContextClassLoader(this.xtraClassLoader);
            DatabaseConnection.setDriverClassLoader(this.xtraClassLoader);
            try {
                Class<?> c = Class.forName("com.incors.plaf.kunststoff.KunststoffLookAndFeel", true, this.xtraClassLoader);
                LookAndFeel laf = (LookAndFeel)c.newInstance();
                UIManager.installLookAndFeel(laf.getName(), c.getName());
                laf = null;
                c = null;
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.I00acres.isql.util.iSQLConfig");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.xtraClassLoader = clazz.getClassLoader();
            ExtensionFactory.updateClassLoader(this.xtraClassLoader);
            UIManager.put("ClassLoader", this.xtraClassLoader);
            Thread.currentThread().setContextClassLoader(this.xtraClassLoader);
            DatabaseConnection.setDriverClassLoader(this.xtraClassLoader);
        }
    }

    public xProperties loadJDBCPropertiesForService(String service) {
        xProperties xProps;
        block4: {
            xProps = new xProperties(this.getJDBCDefaults());
            File extDir = iSQLConfig.getiSQLSubDir("ext");
            File file = new File(extDir, service.replace(' ', '_').concat(".jdbc.properties"));
            try {
                if (!file.exists()) break block4;
                FileInputStream finput = new FileInputStream(file);
                xProps.load(finput);
                try {
                    finput.close();
                }
                catch (IOException iOException) {}
                finput = null;
            }
            catch (IOException ioe) {
                iSQLUtilites.HandleException(ioe, iSQLUtilites.getString("Error_Reading_File", file.getAbsolutePath()), true);
            }
        }
        return xProps;
    }

    public Properties loadXtendedPropertiesForService(String service) {
        Properties xProps;
        block6: {
            xProps = new Properties();
            File extDir = iSQLConfig.getiSQLSubDir("ext");
            File file = new File(extDir, service.replace(' ', '_'));
            try {
                if (!file.exists()) break block6;
                FileInputStream finput = new FileInputStream(file);
                xProps.load(finput);
                try {
                    finput.close();
                }
                catch (IOException iOException) {}
                finput = null;
            }
            catch (IOException ioe) {
                iSQLUtilites.HandleException(ioe, iSQLUtilites.getString("Error_Reading_File", file.getAbsolutePath()), true);
            }
        }
        if (!((Hashtable)xProps).containsKey("user")) {
            xProps.setProperty("user", "");
        }
        if (!((Hashtable)xProps).containsKey("password")) {
            xProps.setProperty("password", "");
        }
        return xProps;
    }

    public void setServerList(String[] servers) {
        Enumeration e = ((Hashtable)this).keys();
        while (e.hasMoreElements()) {
            String server = (String)e.nextElement();
            if (!server.startsWith("Server.")) continue;
            ((Hashtable)this).remove(server);
        }
        int i = 0;
        while (i < servers.length) {
            ((Hashtable)this).put("Server." + i, servers[i]);
            ++i;
        }
    }

    public void clear() {
        super.clear();
        this.setBooleanProperty("General.StorePlainTextPassword", !this.containsEncPasswords);
    }

    public synchronized Properties getAllServiceProperties() {
        Properties sProps = new Properties();
        String[] services = this.getAvailableServices();
        sProps.setProperty("ServerList", this.getStringProperty("ServerList"));
        boolean decrypt = !this.getBooleanProperty("General.StorePlainTextPassword");
        int i = 0;
        while (i < services.length) {
            String Key2 = "Server." + services[i] + ".user";
            sProps.setProperty(Key2, this.getStringProperty(Key2, ""));
            Key2 = "Server." + services[i] + ".url";
            sProps.setProperty(Key2, this.getStringProperty(Key2, ""));
            Key2 = "Server." + services[i] + ".driver";
            sProps.setProperty(Key2, this.getStringProperty(Key2, ""));
            Key2 = "Server." + services[i] + ".useExt";
            sProps.setProperty(Key2, this.getStringProperty(Key2, ""));
            Key2 = "Server." + services[i] + ".prompt";
            sProps.setProperty(Key2, this.getStringProperty(Key2, ""));
            Key2 = "Server." + services[i] + ".pass";
            sProps.setProperty(Key2, decrypt ? this.decryptString(this.getStringProperty(Key2, "")) : this.getStringProperty(Key2, ""));
            Key2 = "Server." + services[i] + ".useDiscreteConfig";
            sProps.setProperty(Key2, this.getStringProperty(Key2, "false"));
            ++i;
        }
        return sProps;
    }

    public synchronized void setServices(Map map) {
        iSQLConfig iSQLConfig2 = this;
        synchronized (iSQLConfig2) {
            this.removeAll(this.getAllServiceProperties());
            ((Hashtable)this).putAll(map);
            if (this.containsEncPasswords) {
                this.containsEncPasswords = false;
                this.validateServices(true);
            }
        }
    }

    public File getLastHistoryLocation() {
        return new File(iSQLConfig.getiSQLSubDir("history"), "autoload.sql");
    }

    public File getLastHistoryLocation(DatabaseConnection service) {
        return new File(iSQLConfig.getiSQLSubDir("history"), "autoload." + service.getConnectionName() + ".sql");
    }

    public Collection getLastHistorySet(DatabaseConnection service) {
        return this.getHistorySet(new File(iSQLConfig.getiSQLSubDir("history"), "autoload." + service.getConnectionName() + ".sql"));
    }

    public Collection getLastHistorySet() {
        return this.getHistorySet(new File(iSQLConfig.getiSQLSubDir("history"), "autoload.sql"));
    }

    public synchronized void validateServices() {
        this.validateServices(!this.getBooleanProperty("General.StorePlainTextPassword"));
    }

    public synchronized void validateServices(boolean doEncryption) {
        String[] services = this.getAvailableServices();
        iSQLConfig iSQLConfig2 = this;
        synchronized (iSQLConfig2) {
            int i = 0;
            while (i < services.length) {
                String key = "Server." + services[i] + ".pass";
                if (this.containsEncPasswords && !doEncryption) {
                    this.setProperty(key, this.decryptString(this.getProperty(key)));
                } else if (!this.containsEncPasswords && doEncryption) {
                    this.setProperty(key, this.encryptString(this.getProperty(key)));
                }
                ++i;
            }
        }
        if (doEncryption) {
            this.containsEncPasswords = true;
            this.setBooleanProperty("General.StorePlainTextPassword", false);
        }
    }

    public Object[] performWebCheck() throws Exception {
        Object[] objectArray = new Object[3];
        objectArray[2] = Boolean.FALSE;
        Object[] returns = objectArray;
        URL homeURL = new URL("http://isql.sourceforge.net/version.php");
        URLConnection httpConnection = homeURL.openConnection();
        httpConnection.connect();
        returns[1] = httpConnection.getHeaderField("iSQL-Version");
        returns[0] = httpConnection.getHeaderField("Version-Type");
        String webver = returns[1].toString();
        int idxa = 0;
        int idxb = webver.indexOf(46, idxa);
        int webmaj = Integer.parseInt(webver.substring(idxa, idxb));
        idxa = idxb + 1;
        idxb = webver.indexOf(46, idxa);
        int webmin = Integer.parseInt(webver.substring(idxa, idxb));
        idxa = idxb + 1;
        int webbuild = Integer.parseInt(webver.substring(idxa));
        int webchecksum = 100 * webmaj + 10 * webmin + webbuild;
        int localchecksum = 210;
        returns[2] = new Boolean(webchecksum > localchecksum);
        return returns;
    }

    public Collection getHistorySet(File f) {
        ArrayList<String> v = new ArrayList<String>(this.getIntProperty("General.History.MaxSize"));
        try {
            if (!f.exists()) {
                f.createNewFile();
            }
            BufferedReader r = new BufferedReader(new FileReader(f));
            while (r.ready()) {
                String s = r.readLine();
                v.add(s);
            }
            v.trimToSize();
        }
        catch (Exception e) {
            iSQLUtilites.HandleException(e, iSQLUtilites.getString("History_Autoload_Error"));
        }
        return v;
    }

    protected synchronized void optimize() {
        boolean saveMetrics = this.getBooleanProperty("General.EnableUserMetrics");
        Enumeration enumeration = ((Hashtable)this).keys();
        while (enumeration.hasMoreElements()) {
            String K = enumeration.nextElement().toString();
            String V = ((Hashtable)this).get(K).toString();
            if (V.trim().length() != 0 && (saveMetrics || !K.startsWith("Session"))) continue;
            ((Hashtable)this).remove(K);
        }
    }

    private void initDriverDefinitions(boolean override) {
        File fDrivers = new File(baseDirectory, fDriverDefs);
        if (!fDrivers.exists() || override) {
            try {
                fDrivers.createNewFile();
                String[] Driverlist = new String[]{"com.lutris.instantdb.jdbc.idbDriver", "org.postgresql.Driver", "org.gjt.mm.mysql.Driver", "com.informix.jdbc.IfxDriver", "interbase.interclient.Driver", "com.sybase.jdbc2.jdbc.SybDriver", "COM.ibm.db2.jdbc.net.DB2Driver", "oracle.jdbc.driver.OracleDriver", "com.imaginary.sql.msql.MsqlDriver", "weblogic.jdbc.mssqlserver4.Driver", "uk.co.thinksql.ThinkSQLDriver", "com.novell.sql.LDAPDriver", "sun.jdbc.odbc.JdbcOdbcDriver", "org.hsqldb.jdbcDriver"};
                String[] URLList = new String[]{"jdbc:idb://Examples/sample.prp", "jdbc:postgresql://myserver/dbname", "jdbc:mysql://hostname/dbname", "jdbc:interbase://d:/databases/employee.gdb", "jdbc:informix-sqli://hostname:1526/dbname:informixserver=dbserver", "jdbc:sybase:Tds:hostname:2025", "db2://hostname:50002/database", "jdbc:oracle:thin:@hostname:1521:ORCL", "jdbc:msql://servername:1114/test", "weblogic:mssqlserver4:hostname:1433", "jdbc:thinksql://localhost:9075", "jdbc:ldap://server;user=cn=sammy,ou=sales,o=acme;password=mypassword;basDN=ou=sales,o=acme;useCleartext=true", "jdbc:odbc:odbcDataSource", "jdbc:hsqldb:/tmp/db"};
                Properties props = new Properties();
                int i = 0;
                while (i < Driverlist.length) {
                    props.setProperty(Driverlist[i], URLList[i]);
                    ++i;
                }
                FileOutputStream fos = new FileOutputStream(fDrivers);
                props.store(fos, "iSQL-Viewer JDBC Driver Definitions [ClassName] = [Example URL]");
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
                fos = null;
                props = null;
                Driverlist = null;
                URLList = null;
            }
            catch (IOException iOException) {}
        }
    }

    private synchronized void removeDeprecatedProperties() {
    }

    private String encryptString(String Word) {
        if (Word == null) {
            return "";
        }
        if (Word.length() < xorKey.length) {
            int pad = xorKey.length - Word.length();
            byte[] padkey = new byte[pad];
            int i = 0;
            while (i < pad) {
                padkey[i] = xorKey[i];
                ++i;
            }
            Word = Word.concat(new String(padkey));
        }
        byte[] pass = Word.getBytes();
        byte[] xorStr = new byte[pass.length];
        int j = 0;
        int i = 0;
        while (i < pass.length) {
            if (j >= xorKey.length) {
                j = 0;
            }
            xorStr[i] = (byte)(xorKey[j++] ^ pass[i]);
            ++i;
        }
        String str = new String(xorStr);
        return str.trim();
    }

    private final String decryptString(String str) {
        if (str == null) {
            return "";
        }
        byte[] bytes = str.getBytes();
        byte[] xorStr = new byte[bytes.length];
        int j = 0;
        int i = 0;
        while (i < bytes.length) {
            if (j >= xorKey.length) {
                j = 0;
            }
            xorStr[i] = (byte)(bytes[i] ^ xorKey[j++]);
            ++i;
        }
        String newStr = new String(xorStr);
        newStr.replace('\u0000', ' ');
        return newStr.trim();
    }

    private void load() {
        if (!baseDirectory.exists()) {
            baseDirectory.mkdirs();
        }
        File prefrences = new File(baseDirectory, fPrefrences);
        try {
            if (!prefrences.exists()) {
                prefrences.createNewFile();
            }
        }
        catch (IOException ioe) {
            iSQLUtilites.HandleException(ioe, iSQLUtilites.getString("CFG_INIT_ERROR", prefrences.getAbsolutePath()), false);
        }
        try {
            FileInputStream finput = new FileInputStream(prefrences);
            this.load(finput);
            finput.close();
        }
        catch (IOException iOException) {}
        String s = this.getProperty("iSQL-Version");
        if (!s.equalsIgnoreCase(ISQL_VERSION)) {
            this.initDriverDefinitions(true);
            this.removeDeprecatedProperties();
            this.save();
        } else {
            this.initDriverDefinitions(false);
        }
    }

    private static Properties getDefaults() {
        xProperties def = new xProperties();
        def.setStringProperty("iSQL-Version", ISQL_VERSION);
        def.setStringProperty("ServerList", "");
        def.setFontProperty("Print.Header", new Font("Lucinda Sans", 1, 11));
        def.setBooleanProperty("Print.Table.DownOver", false);
        def.setBooleanProperty("Print.IncludePageHeader", true);
        def.setBooleanProperty("Print.IncludePageFooter", true);
        def.setBooleanProperty("Print.IncludeGridlines", true);
        def.setBooleanProperty("Print.UseColor", true);
        def.setIntProperty("General.History.MaxSize", 64);
        def.setIntProperty("General.MaxResultSetCount", 10);
        def.setBooleanProperty("General.ShowHiddenFiles", false);
        def.setBooleanProperty("ToolBar.History.visible", true);
        def.setBooleanProperty("ToolBar.File.visible", true);
        def.setBooleanProperty("ToolBar.ResultSet.visible", true);
        def.setStringProperty("ToolBar.History.Dock", "North");
        def.setStringProperty("ToolBar.File.Dock", "North");
        def.setStringProperty("ToolBar.ResultSet.Dock", "West");
        def.setStringProperty("General.ResultTabFmt", "%s :: %T");
        def.setStringProperty("General.LAF", UIManager.getSystemLookAndFeelClassName());
        def.setBooleanProperty("General.UseDiscreteHistory", false);
        def.setBooleanProperty("General.EnableUserMetrics", false);
        def.setBooleanProperty("General.UseLastGeometry", false);
        def.setBooleanProperty("General.AutoClear", false);
        def.setBooleanProperty("General.EnableUserMetrics", false);
        def.setBooleanProperty("General.StorePlainTextPassword", true);
        def.setBooleanProperty("General.History.Autoload", true);
        def.setBooleanProperty("General.RefreshSameTab", true);
        def.setBooleanProperty("General.UseLargeIcons", true);
        def.setBooleanProperty("General.ShowSplash", true);
        def.setBooleanProperty("Advanced.AutoVersionCheck", false);
        def.setStringProperty("Advanced.XtraClassPaths", "");
        def.setIntProperty("Advanced.AutoVersionCheck.Type", 0);
        def.setBooleanProperty("JDBC.Use-Startup", false);
        def.setBooleanProperty("JDBC.Verbose", false);
        def.setBooleanProperty("JDBC.Debug-Mode", false);
        def.setBooleanProperty("JDBC.EnableTrace", false);
        def.setBooleanProperty("JDBC.FetchReverse", false);
        def.setBooleanProperty("JDBC.EscapeProcess", false);
        def.setBooleanProperty("JDBC.Auto-Connect", true);
        def.setBooleanProperty("JDBC.EchoRecordCount", true);
        def.setBooleanProperty("JDBC.Log-Queries", true);
        def.setIntProperty("JDBC.LoginTimeout", 0);
        def.setIntProperty("JDBC.QueryTimeout", 0);
        def.setIntProperty("JDBC.MaxFieldSize", 0);
        def.setIntProperty("JDBC.MaxResultSetSize", 0);
        def.setBooleanProperty("Print.IncludePageHeader", true);
        def.setBooleanProperty("Print.IncludePageFooter", true);
        def.setBooleanProperty("Print.IncludeGridlines", true);
        def.setBooleanProperty("Print.UseColor", true);
        def.setBooleanProperty("Print.Table.DownOver", true);
        return def;
    }

    private Properties getJDBCDefaults() {
        xProperties def = new xProperties();
        def.setBooleanProperty("JDBC.Verbose", this.getBooleanProperty("JDBC.Verbose"));
        def.setBooleanProperty("JDBC.Debug-Mode", this.getBooleanProperty("JDBC.Debug-Mode"));
        def.setBooleanProperty("JDBC.EnableTrace", this.getBooleanProperty("JDBC.EnableTrace"));
        def.setBooleanProperty("JDBC.FetchReverse", this.getBooleanProperty("JDBC.FetchReverse"));
        def.setBooleanProperty("JDBC.EscapeProcess", this.getBooleanProperty("JDBC.EscapeProcess"));
        def.setBooleanProperty("JDBC.Auto-Connect", this.getBooleanProperty("JDBC.Auto-Connect"));
        def.setBooleanProperty("JDBC.EchoRecordCount", this.getBooleanProperty("JDBC.EchoRecordCount"));
        def.setBooleanProperty("JDBC.Log-Queries", this.getBooleanProperty("JDBC.Log-Queries"));
        def.setIntProperty("JDBC.LoginTimeout", this.getIntProperty("JDBC.LoginTimeout"));
        def.setIntProperty("JDBC.QueryTimeout", this.getIntProperty("JDBC.QueryTimeout"));
        def.setIntProperty("JDBC.MaxFieldSize", this.getIntProperty("JDBC.MaxFieldSize"));
        def.setIntProperty("JDBC.MaxResultSetSize", this.getIntProperty("JDBC.MaxResultSetSize"));
        return def;
    }
}

