/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.lib.sql;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.Vector;
import org.I00acres.lib.sql.DatabaseConnection;
import org.I00acres.lib.util.xProperties;

public final class BatchRunner
extends Thread
implements ActionListener {
    public static final int MOD_EXECUTING_BATCH = 4;
    public static final int MOD_LOADING_STATEMENTS = 2;
    private static final int MOD_IDLE = 0;
    public static final ThreadGroup BATCH_THREAD_GROUP = new ThreadGroup("iSQL-Batch-Reader(s)");
    static ResourceBundle res = ResourceBundle.getBundle("org.I00acres.lib.sql.ResourceStrings");
    private StreamTokenizer mStreamTokenizer;
    private Vector mBatchStatements = new Vector();
    private BufferedReader br;
    private File mFile;
    private ActionListener mNotifyer;
    private DatabaseConnection dbc;
    private xProperties config;
    private boolean pendingBatchExecution = false;
    private boolean useTrans = false;
    private boolean halt = false;
    private boolean isPaused = false;
    private boolean inProcess = false;
    private boolean isLoaded = false;
    private boolean overrideBatch;
    private int ID = 0;
    private int MODE = -1;

    static {
        BATCH_THREAD_GROUP.setMaxPriority(5);
    }

    public BatchRunner(File f, int pID, ActionListener pProgressListener) throws IOException {
        super(BATCH_THREAD_GROUP, f.getName());
        this.setDaemon(false);
        this.setPriority(5);
        this.mNotifyer = pProgressListener;
        this.mFile = f;
        this.ID = pID;
        this.start();
    }

    private synchronized void reconfigureParser() throws IOException {
        this.br = new BufferedReader(new FileReader(this.mFile), 512);
        this.mStreamTokenizer = new StreamTokenizer(this.br);
        this.mBatchStatements.clear();
        this.isLoaded = false;
        this.mStreamTokenizer.resetSyntax();
        this.mStreamTokenizer.wordChars(32, 128);
        this.mStreamTokenizer.wordChars(160, 255);
        this.mStreamTokenizer.whitespaceChars(0, 31);
        this.mStreamTokenizer.lowerCaseMode(this.config.getBooleanProperty("Batch.LowerCase", false));
        switch (this.config.getIntProperty("Batch.Literal.Style", 0)) {
            case 1: {
                break;
            }
            case 2: {
                this.mStreamTokenizer.quoteChar(39);
                break;
            }
            case 3: {
                this.mStreamTokenizer.quoteChar(this.config.getCharacterProperty("Batch.Literal.Value", '\"'));
                break;
            }
            default: {
                this.mStreamTokenizer.quoteChar(34);
            }
        }
        switch (this.config.getIntProperty("Batch.Comment.Style", 0)) {
            case 1: {
                break;
            }
            case 2: {
                this.mStreamTokenizer.slashSlashComments(true);
                break;
            }
            case 3: {
                this.mStreamTokenizer.slashStarComments(true);
                break;
            }
            default: {
                this.mStreamTokenizer.commentChar(this.config.getCharacterProperty("Batch.Comment.Char", '#'));
            }
        }
        switch (this.config.getIntProperty("Batch.Seperator.Style", 0)) {
            case 1: {
                this.mStreamTokenizer.eolIsSignificant(true);
                break;
            }
            default: {
                char c = this.config.getCharacterProperty("Batch.Seperator.Char", ';');
                this.mStreamTokenizer.ordinaryChar(c);
            }
        }
    }

    public File getBatchFile() {
        return this.mFile;
    }

    public int getBatchID() {
        return this.ID;
    }

    public synchronized void loadStatements() {
        BatchRunner batchRunner = this;
        synchronized (batchRunner) {
            if (!this.inProcess) {
                this.MODE = 2;
                this.halt = false;
                this.inProcess = false;
                this.isLoaded = false;
                this.isPaused = false;
                this.notify();
            }
        }
    }

    public synchronized void setBatchStatements(Collection Statements) {
        if (Statements == null) {
            throw new NullPointerException();
        }
        BatchRunner batchRunner = this;
        synchronized (batchRunner) {
            this.mBatchStatements.clear();
            this.mBatchStatements.addAll(Statements);
        }
        this.isLoaded = true;
    }

    public void setProperties(xProperties pConfiguration) {
        if (pConfiguration == null) {
            throw new NullPointerException(res.getString("Properties_Null_Pointer"));
        }
        this.config = pConfiguration;
        try {
            this.reconfigureParser();
        }
        catch (Throwable t) {
            this.isLoaded = false;
            DatabaseConnection.log(res.getString("_Error_Occured_While"));
            DatabaseConnection.log(String.valueOf(res.getString("Exception_")) + t.toString());
            if (this.mNotifyer != null) {
                this.mNotifyer.actionPerformed(new ActionEvent(this, this.getBatchID(), "100", 4));
                this.mNotifyer.actionPerformed(new ActionEvent(this, this.getBatchID(), "-1", 2));
            }
            this.MODE = 0;
            this.inProcess = false;
            this.isPaused = false;
            this.mStreamTokenizer = null;
        }
    }

    public synchronized void setConnection(DatabaseConnection pConnection) {
        if (!this.inProcess) {
            BatchRunner batchRunner = this;
            synchronized (batchRunner) {
                this.dbc = pConnection;
            }
        }
    }

    public DatabaseConnection getConnection() {
        return this.dbc;
    }

    public synchronized void unpause() {
        if (this.inProcess) {
            BatchRunner batchRunner = this;
            synchronized (batchRunner) {
                this.isPaused = false;
                this.notify();
            }
        }
    }

    public synchronized void pause() {
        if (this.inProcess) {
            BatchRunner batchRunner = this;
            synchronized (batchRunner) {
                this.isPaused = true;
            }
        } else {
            this.isPaused = false;
        }
    }

    public synchronized boolean isInProcess() {
        return this.inProcess;
    }

    public synchronized boolean isLoaded() {
        return this.isLoaded;
    }

    synchronized boolean shouldPause() {
        return this.isPaused;
    }

    synchronized boolean shouldHalt() {
        return this.halt;
    }

    synchronized boolean shouldCancel() {
        return !this.inProcess;
    }

    public synchronized void cancel() {
        if (this.inProcess) {
            BatchRunner batchRunner = this;
            synchronized (batchRunner) {
                this.inProcess = false;
                this.isPaused = false;
                this.halt = false;
                this.MODE = -1;
            }
        }
    }

    public synchronized void halt() {
        BatchRunner batchRunner = this;
        synchronized (batchRunner) {
            this.inProcess = false;
            this.isPaused = false;
            this.halt = true;
            this.MODE = -1;
            this.notify();
            if (this.dbc != null) {
                this.dbc.disconnect();
            }
        }
    }

    public synchronized boolean isIdle() {
        return this.MODE == 0 && this.isAlive() && !this.inProcess;
    }

    private synchronized void executeBatch() {
        if (this.mBatchStatements.isEmpty() && this.isLoaded) {
            if (this.mNotifyer != null) {
                this.mNotifyer.actionPerformed(new ActionEvent(this, this.getBatchID(), "100", 4));
            }
            return;
        }
        if (!this.isLoaded) {
            return;
        }
        BatchRunner batchRunner = this;
        synchronized (batchRunner) {
            DatabaseConnection.logEvent(String.valueOf(res.getString("BatchRunner_1")) + this.getBatchID() + res.getString("_Creating_Connection"));
            if (this.dbc == null) {
                DatabaseConnection.logEvent(String.valueOf(res.getString("BatchRunner_1")) + this.getBatchID() + res.getString("_Could_Not_Create") + res.getString("KEY2"));
                this.inProcess = false;
                this.MODE = 0;
                this.pendingBatchExecution = false;
                if (this.mNotifyer != null) {
                    this.mNotifyer.actionPerformed(new ActionEvent(this, this.getBatchID(), "100", 4));
                }
                return;
            }
            try {
                if (!this.dbc.init()) {
                    DatabaseConnection.logEvent(String.valueOf(res.getString("BatchRunner_1")) + this.getBatchID() + res.getString("_Could_Not_Create") + res.getString("KEY2"));
                    this.inProcess = false;
                    this.pendingBatchExecution = false;
                    this.MODE = 0;
                    if (this.mNotifyer != null) {
                        this.mNotifyer.actionPerformed(new ActionEvent(this, this.getBatchID(), "100", 4));
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                DatabaseConnection.logEvent(String.valueOf(res.getString("BatchRunner_1")) + this.getBatchID() + res.getString("_Could_Not_Create") + res.getString("KEY2"));
                this.inProcess = false;
                this.pendingBatchExecution = false;
                this.MODE = 0;
                if (this.mNotifyer != null) {
                    this.mNotifyer.actionPerformed(new ActionEvent(this, this.getBatchID(), "100", 4));
                }
                return;
            }
            this.inProcess = true;
            DatabaseConnection.logEvent(String.valueOf(res.getString("BatchRunner_1")) + this.getBatchID() + res.getString("_Starting_Batch"));
            int c = this.dbc.doBatch(this.mBatchStatements, this.overrideBatch, this.useTrans, this);
            DatabaseConnection.logEvent(String.valueOf(res.getString("BatchRunner_1")) + this.getBatchID() + res.getString("_Finished_Batch_") + c + res.getString("KEY3"));
            this.inProcess = false;
            this.isPaused = false;
            this.pendingBatchExecution = false;
            System.runFinalization();
            this.MODE = 0;
        }
    }

    public synchronized void execute(boolean useTransaction, boolean overrideSupport) {
        if (this.pendingBatchExecution) {
            return;
        }
        BatchRunner batchRunner = this;
        synchronized (batchRunner) {
            this.useTrans = useTransaction;
            this.overrideBatch = overrideSupport;
            this.halt = false;
            this.isPaused = false;
            if (this.isLoaded && !this.inProcess && !this.halt) {
                this.pendingBatchExecution = false;
                this.MODE = 4;
                this.notify();
            } else if (!this.isLoaded && !this.halt) {
                this.pendingBatchExecution = true;
            }
        }
    }

    private synchronized void loadBatchStatements() throws Exception {
        if (this.mStreamTokenizer == null) {
            DatabaseConnection.logEvent(String.valueOf(res.getString("BatchRunner_1")) + this.getBatchID() + res.getString("_Parser_Is_Not"));
            BatchRunner batchRunner = this;
            synchronized (batchRunner) {
                this.inProcess = false;
                this.isPaused = false;
                this.isLoaded = false;
                this.halt = true;
                this.MODE = 0;
                this.pendingBatchExecution = false;
            }
            if (this.mNotifyer != null) {
                this.mNotifyer.actionPerformed(new ActionEvent(this, this.getBatchID(), "-1", 2));
                this.mNotifyer.actionPerformed(new ActionEvent(this, this.getBatchID(), "100", 4));
            }
            return;
        }
        BatchRunner batchRunner = this;
        synchronized (batchRunner) {
            this.inProcess = true;
            int TokenType = 0;
            boolean useEOL = this.config.getIntProperty("Batch.Seperator.Style", 0) == 1;
            char StatementToken = this.config.getCharacterProperty("Batch_Seperator_Char", ';');
            StringBuffer buff = new StringBuffer("");
            DatabaseConnection.logEvent(String.valueOf(res.getString("BatchRunner_1")) + this.getBatchID() + res.getString("_Starting_Statement"));
            while ((TokenType = this.mStreamTokenizer.nextToken()) != -1) {
                if (TokenType == 10 && useEOL) {
                    if (this.mStreamTokenizer.sval != null && this.mStreamTokenizer.sval.trim().length() >= 1) {
                        this.mBatchStatements.add(this.mStreamTokenizer.sval);
                    }
                } else {
                    if (TokenType == -3 && useEOL) {
                        buff.append(this.mStreamTokenizer.sval.trim().concat(" "));
                        this.mBatchStatements.add(buff.toString().trim());
                        buff.setLength(0);
                        continue;
                    }
                    if (TokenType == -3) {
                        if (this.mStreamTokenizer.sval != null && this.mStreamTokenizer.sval.trim().length() >= 1) {
                            buff.append(this.mStreamTokenizer.sval.trim().concat(" "));
                        }
                    } else if (!useEOL && TokenType == StatementToken) {
                        this.mBatchStatements.add(buff.toString());
                        buff.setLength(0);
                    }
                }
                if (!this.inProcess && !this.isPaused || this.halt) {
                    DatabaseConnection.logEvent(String.valueOf(res.getString("BatchRunner_1")) + this.getBatchID() + res.getString("_Halting_Statment"));
                    this.mBatchStatements.clear();
                    return;
                }
                if (!this.inProcess || !this.isPaused) continue;
                DatabaseConnection.logEvent(String.valueOf(res.getString("BatchRunner_1")) + this.getBatchID() + res.getString("_Pausing_Statment"));
                this.wait();
            }
            if (this.mNotifyer != null) {
                this.mNotifyer.actionPerformed(new ActionEvent(this, this.getBatchID(), Integer.toString(this.mBatchStatements.size()), 2));
            }
            this.inProcess = false;
            this.isLoaded = true;
            DatabaseConnection.logEvent(String.valueOf(res.getString("BatchRunner_1")) + this.getBatchID() + res.getString("KEY4") + this.mBatchStatements.size() + res.getString("_Finished_Statement"));
        }
    }

    public void run() {
        while (!this.halt) {
            try {
                switch (this.MODE) {
                    case 2: {
                        this.loadBatchStatements();
                        break;
                    }
                    case 4: {
                        this.executeBatch();
                        break;
                    }
                }
                BatchRunner batchRunner = this;
                synchronized (batchRunner) {
                    try {
                        if (this.halt) {
                            continue;
                        }
                        if (this.pendingBatchExecution && this.isLoaded) {
                            this.MODE = 4;
                            continue;
                        }
                        this.pendingBatchExecution = false;
                        this.inProcess = false;
                        this.isPaused = false;
                        this.wait();
                    }
                    catch (Exception exception) {
                        this.MODE = 0;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mBatchStatements.clear();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof DatabaseConnection && this.mNotifyer != null) {
            this.mNotifyer.actionPerformed(new ActionEvent(this, this.getBatchID(), e.getActionCommand(), e.getModifiers()));
        }
    }
}

