/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.lib.sql;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import org.I00acres.lib.sql.BatchRunner;
import org.I00acres.lib.sql.ResultSetUtilities;
import org.I00acres.lib.sql.ResultSetViewer;

public final class DatabaseConnection {
    static ResourceBundle resStrings = ResourceBundle.getBundle("org.I00acres.lib.sql.ResourceStrings");
    private static boolean _ShowStackTraces = false;
    private static boolean _EnableAutoReconnect = false;
    private static boolean _ShowExceptions = false;
    private static boolean _ShowQueries = false;
    private static boolean _UseReverseFetch = false;
    private static boolean _UseEscapeProcessing = true;
    private static ClassLoader _DriverLoader;
    private static int _QueryTimeout;
    private static int _MaxRowCount;
    private static int _MaxFieldSize;
    private static boolean _PropertyChangeFlag;
    private transient Connection mConnection;
    private transient Throwable lastError;
    private transient boolean mTransactionFlag = false;
    private transient boolean mBatchFlag = false;
    private transient boolean mMRFlag = false;
    private transient PrintWriter tracer = null;
    private Properties props;
    private String mConicalName;
    private String CQuery;
    private Hashtable mConnectionInfo;
    String mCatalog;
    String _url;
    Driver _driver;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.I00acres.lib.sql.DatabaseConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _DriverLoader = clazz.getClassLoader();
        _QueryTimeout = 30;
        _MaxRowCount = 0;
        _MaxFieldSize = 0;
        _PropertyChangeFlag = false;
    }

    public DatabaseConnection(String jdbcURL, String jdbcUser, String jdbcPass, String jdbcDriver) throws ClassNotFoundException, SQLException {
        try {
            this._driver = (Driver)Class.forName(jdbcDriver, true, _DriverLoader).newInstance();
            DriverManager.registerDriver(this._driver);
            this.tracer = DriverManager.getLogWriter();
        }
        catch (InstantiationException e) {
            this.HandleException(e);
            return;
        }
        catch (IllegalAccessException e) {
            this.HandleException(e);
            return;
        }
        this._url = jdbcURL;
        this.props = new Properties();
        ((Hashtable)this.props).put("user", jdbcUser);
        ((Hashtable)this.props).put("password", jdbcPass);
    }

    public DatabaseConnection(String jdbcURL, String DriverClassName, Properties jdbcProps) throws ClassNotFoundException, SQLException {
        try {
            this._driver = (Driver)Class.forName(DriverClassName, true, _DriverLoader).newInstance();
            DriverManager.registerDriver(this._driver);
        }
        catch (InstantiationException e) {
            this.HandleException(e);
            return;
        }
        catch (IllegalAccessException e) {
            this.HandleException(e);
            return;
        }
        this._url = jdbcURL;
        this.props = new Properties();
        ((Hashtable)this.props).putAll(jdbcProps);
    }

    protected void trace(String msg) {
        try {
            this.tracer.println(msg);
        }
        catch (Throwable throwable) {}
    }

    Properties getConnectionProperties() {
        return this.props;
    }

    public void updateAutheticationTokens(String user, String pass) {
        ((Hashtable)this.props).put("user", user);
        ((Hashtable)this.props).put("password", pass);
    }

    public DriverPropertyInfo[] getDriverProperties(Properties defaults) throws SQLException {
        if (this._driver != null) {
            return this._driver.getPropertyInfo(this._url, defaults);
        }
        return new DriverPropertyInfo[0];
    }

    public Driver getDriverClass() {
        return this._driver;
    }

    public void changeCatalog(String newCatalog) throws SQLException {
        this.mConnection.setCatalog(newCatalog);
        this.mCatalog = newCatalog;
    }

    public String getCatalog() {
        return this.mCatalog;
    }

    public boolean isBatchSupported() {
        return this.mBatchFlag;
    }

    public boolean isTransactionsSupported() {
        return this.mTransactionFlag;
    }

    public synchronized void setAutoCommit(boolean flag) {
        try {
            this.mConnection.setAutoCommit(flag);
        }
        catch (Throwable e) {
            this.HandleException(e);
        }
    }

    public synchronized void performRollBack() {
        try {
            Connection connection = this.mConnection;
            synchronized (connection) {
                this.mConnection.rollback();
            }
        }
        catch (Throwable e) {
            this.HandleException(e);
        }
    }

    public SQLWarning getConnectionWarnings() {
        try {
            return this.mConnection.getWarnings();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public boolean getAutoCommit() {
        try {
            return this.mConnection.getAutoCommit();
        }
        catch (Throwable e) {
            this.HandleException(e);
            return false;
        }
    }

    public synchronized int doBatch(Vector batchList) {
        return this.doBatch(batchList, false, false, null);
    }

    public synchronized int doBatch(Vector batchList, boolean overridesupport, boolean useTransaction, ActionListener ProgressListener) {
        BatchRunner reader = Thread.currentThread() instanceof BatchRunner ? (BatchRunner)Thread.currentThread() : null;
        try {
            block48: {
                Statement mStatement = this.initStatement();
                double size = batchList.size();
                Enumeration enumeration = batchList.elements();
                if (useTransaction) {
                    try {
                        this.setAutoCommit(false);
                    }
                    catch (Exception exception) {
                        DatabaseConnection.logEvent(resStrings.getString("_Warning_Could_Not"));
                    }
                }
                boolean supportsbatch = false;
                try {
                    supportsbatch = this.mConnection.getMetaData().supportsBatchUpdates();
                }
                catch (Exception exception) {}
                if (supportsbatch && !overridesupport) {
                    int k = 0;
                    while (enumeration.hasMoreElements()) {
                        mStatement.addBatch(enumeration.nextElement().toString());
                        double p = 100.0 * ((double)(++k) / size);
                        if (ProgressListener != null) {
                            ProgressListener.actionPerformed(new ActionEvent(this, k, Integer.toString((int)p), 4));
                        }
                        try {
                            if (reader != null) {
                                if ((reader.shouldCancel() || reader.shouldHalt()) && enumeration.hasMoreElements()) {
                                    DatabaseConnection.logEvent(String.valueOf(resStrings.getString("BatchRunner_")) + reader.getBatchID() + resStrings.getString("_Recieved_Halt_Signal") + k);
                                    if (!this.getAutoCommit() && useTransaction) {
                                        try {
                                            this.performRollBack();
                                        }
                                        catch (Exception exception) {}
                                    }
                                    if (ProgressListener != null) {
                                        ProgressListener.actionPerformed(new ActionEvent(this, 0, "100", 4));
                                    }
                                    return 0;
                                }
                                if (reader.shouldPause()) {
                                    DatabaseConnection.logEvent(String.valueOf(resStrings.getString("BatchRunner_")) + reader.getBatchID() + resStrings.getString("_Pausing_on_Statement") + k);
                                    try {
                                        reader.wait();
                                        DatabaseConnection.logEvent(String.valueOf(resStrings.getString("BatchRunner_")) + reader.getBatchID() + resStrings.getString("_Resuming_on") + (k + 1));
                                    }
                                    catch (Exception exception) {}
                                }
                            }
                            Thread.currentThread().wait(25L);
                        }
                        catch (Exception exception) {}
                    }
                    try {
                        int[] res = mStatement.executeBatch();
                        try {
                            mStatement.clearBatch();
                        }
                        catch (Throwable throwable) {}
                        int i = 0;
                        while (i < res.length) {
                            if (res[i] <= 0 && !this.getAutoCommit()) {
                                this.performRollBack();
                                return i;
                            }
                            ++i;
                        }
                        return res.length;
                    }
                    catch (SQLException sqle) {
                        if (!this.getAutoCommit() && useTransaction) {
                            try {
                                this.performRollBack();
                                return 0;
                            }
                            catch (Exception exception) {
                                this.HandleException(sqle);
                                return 0;
                            }
                        }
                        break block48;
                    }
                }
                int i = 0;
                while (enumeration.hasMoreElements()) {
                    int res;
                    try {
                        res = this.executeUpdate(enumeration.nextElement().toString());
                    }
                    catch (Throwable throwable) {
                        res = -1;
                    }
                    double p = 100.0 * ((double)(++i) / size);
                    if (ProgressListener != null) {
                        ProgressListener.actionPerformed(new ActionEvent(this, i, Integer.toString((int)p), 4));
                    }
                    try {
                        if (reader != null) {
                            if ((reader.shouldCancel() || reader.shouldHalt()) && enumeration.hasMoreElements()) {
                                DatabaseConnection.logEvent(String.valueOf(resStrings.getString("BatchRunner_")) + reader.getBatchID() + resStrings.getString("_Recieved_Halt_Signal") + i);
                                if (!this.getAutoCommit() && useTransaction) {
                                    try {
                                        this.performRollBack();
                                    }
                                    catch (Exception exception) {}
                                }
                                if (ProgressListener != null) {
                                    ProgressListener.actionPerformed(new ActionEvent(this, i, "100", 4));
                                }
                                return i;
                            }
                            if (reader.shouldPause()) {
                                DatabaseConnection.logEvent(String.valueOf(resStrings.getString("BatchRunner_")) + reader.getBatchID() + resStrings.getString("_Pausing_on_Statement") + i);
                                try {
                                    reader.wait();
                                    DatabaseConnection.logEvent(String.valueOf(resStrings.getString("BatchRunner_")) + reader.getBatchID() + resStrings.getString("_Resuming_on") + (i + 1));
                                }
                                catch (Exception exception) {}
                            }
                        }
                        Thread.currentThread().wait(25L);
                    }
                    catch (Exception exception) {}
                    if (res >= 0 || this.getAutoCommit()) continue;
                    this.performRollBack();
                    return i;
                }
            }
            if (useTransaction && !this.getAutoCommit()) {
                try {
                    this.performCommit();
                }
                catch (Exception exception) {}
            }
            return batchList.size();
        }
        catch (Exception e) {
            this.HandleException(e);
            return -1;
        }
    }

    public void setConnectionName(String name) {
        this.mConicalName = new String(name.getBytes());
    }

    public String getConnectionName() {
        if (this.mConicalName == null) {
            return this._url;
        }
        return this.mConicalName;
    }

    public synchronized void performCommit() {
        try {
            Connection connection = this.mConnection;
            synchronized (connection) {
                this.mConnection.commit();
            }
        }
        catch (Throwable e) {
            this.HandleException(e);
        }
    }

    public synchronized void disconnect() {
        DatabaseConnection databaseConnection = this;
        synchronized (databaseConnection) {
            try {
                this.mConnection.clearWarnings();
                this.mConnection.close();
            }
            catch (Throwable throwable) {}
            try {
                DriverManager.deregisterDriver(this._driver);
            }
            catch (Throwable throwable) {}
            this.mConnection = null;
        }
    }

    public boolean init() throws SQLException {
        DatabaseMetaData dmd;
        try {
            this.mConnection = this._driver.connect(this._url, this.props);
        }
        catch (SQLException sqle) {
            throw new SQLException("Connection-Exception :: " + sqle.getLocalizedMessage());
        }
        catch (Throwable t) {
            DatabaseConnection.log(resStrings.getString("_Error_Could_not"));
            this.HandleException(t);
            return false;
        }
        try {
            dmd = this.mConnection.getMetaData();
            this.mTransactionFlag = dmd.supportsTransactions();
        }
        catch (Exception exception) {
            this.mTransactionFlag = false;
        }
        try {
            dmd = this.mConnection.getMetaData();
            this.mBatchFlag = dmd.supportsBatchUpdates();
        }
        catch (Exception exception) {
            this.mBatchFlag = false;
        }
        try {
            dmd = this.mConnection.getMetaData();
            this.mMRFlag = dmd.supportsMultipleResultSets();
        }
        catch (Exception exception) {
            this.mMRFlag = false;
        }
        try {
            this.mCatalog = this.mConnection.getCatalog();
        }
        catch (Exception exception) {
            this.mCatalog = "";
        }
        System.gc();
        System.runFinalization();
        return true;
    }

    public void logDriverInformation() {
        try {
            DatabaseConnection.log(String.valueOf(resStrings.getString("Using")) + " " + this._driver.getClass() + resStrings.getString("Version") + " " + this._driver.getMajorVersion() + "." + this._driver.getMinorVersion());
            if (this._driver.jdbcCompliant()) {
                DatabaseConnection.log(resStrings.getString("Driver_States_that_it"));
            } else {
                DatabaseConnection.log(resStrings.getString("Driver_States_that_it1"));
            }
        }
        catch (Exception exception) {}
    }

    protected synchronized boolean re_init() throws SQLException {
        DatabaseConnection.logEvent(resStrings.getString("Re_Initializing"));
        try {
            this.mConnection.close();
        }
        catch (Exception exception) {}
        return this.init();
    }

    protected void finalize() {
        this.disconnect();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {}
    }

    public PreparedStatement requestInsertPreparedStatement(String Table, String[] Columns) {
        try {
            StringBuffer sql = new StringBuffer("INSERT INTO " + Table + " (");
            int i = 0;
            while (i < Columns.length - 1) {
                sql.append(String.valueOf(Columns[i]) + ",");
                ++i;
            }
            sql.append(String.valueOf(Columns[Columns.length - 1]) + ") VALUES (");
            i = 0;
            while (i < Columns.length - 1) {
                sql.append("?,");
                ++i;
            }
            sql.append("?)");
            return this.mConnection.prepareStatement(sql.toString());
        }
        catch (Throwable t) {
            this.HandleException(t);
            return null;
        }
    }

    public int executePreparedUpdateStatement(String preparedStatement, Vector objs, int[] types) {
        try {
            this.CQuery = preparedStatement;
            PreparedStatement ps = this.mConnection.prepareStatement(preparedStatement);
            int p = 1;
            int i = 0;
            while (i < objs.size()) {
                ps.setObject(p++, objs.elementAt(i), types[i]);
                ++i;
            }
            if (_ShowQueries) {
                DatabaseConnection.log(String.valueOf(resStrings.getString("Executing_Prepared")) + this.CQuery);
            }
            return ps.executeUpdate();
        }
        catch (Exception e) {
            this.HandleException(e);
            return -1;
        }
    }

    public void executeStoredProcedure(String ProcedureName, Vector objs, int[] types, ResultSetViewer viewer) {
        try {
            this.CQuery = ProcedureName;
            CallableStatement cs = this.mConnection.prepareCall(ProcedureName);
            int p = 1;
            int i = 0;
            while (i < objs.size()) {
                cs.setObject(p++, objs.elementAt(i), types[i]);
                ++i;
            }
            if (_ShowQueries) {
                DatabaseConnection.log(String.valueOf(resStrings.getString("Executing_Stored")) + this.CQuery);
            }
            viewer.modelResultSet(cs.executeQuery());
        }
        catch (Exception e) {
            this.HandleException(e);
        }
    }

    public Throwable getLastError() {
        return this.lastError;
    }

    public DatabaseMetaData getDatabaseInformation() {
        try {
            return this.mConnection.getMetaData();
        }
        catch (Exception e) {
            this.HandleException(e);
            return null;
        }
    }

    public void flushConnectionInfo() {
        if (this.mConnectionInfo != null) {
            Hashtable hashtable = this.mConnectionInfo;
            synchronized (hashtable) {
                this.mConnectionInfo.clear();
                this.mConnectionInfo = null;
            }
        }
        System.runFinalization();
    }

    public Hashtable getConnectionInformation() {
        if (this.mConnectionInfo == null) {
            try {
                DatabaseMetaData dmd = this.mConnection.getMetaData();
                Class<?> c = dmd.getClass();
                Method[] methods = c.getMethods();
                this.mConnectionInfo = new Hashtable();
                Object[] p = new Object[]{};
                int i = 0;
                while (i < methods.length) {
                    try {
                        Class<?> cClass = methods[i].getReturnType();
                        String n = methods[i].getName();
                        if (cClass.isPrimitive() || cClass.getName().endsWith("String")) {
                            if (n.startsWith("get")) {
                                n = n.substring(3);
                            }
                            Object res = methods[i].invoke((Object)dmd, p);
                            this.mConnectionInfo.put(n, res.toString());
                        }
                    }
                    catch (Exception exception) {}
                    ++i;
                }
            }
            catch (Exception e) {
                this.HandleException(e);
            }
        }
        return this.mConnectionInfo;
    }

    private synchronized Statement initStatement() throws SQLException {
        Statement sqlStatement = null;
        try {
            sqlStatement = this.mConnection.createStatement();
        }
        catch (SQLException sqle) {
            throw new SQLException("Statement-Exception :: " + sqle.getLocalizedMessage());
        }
        catch (Exception e) {
            DatabaseConnection.log(resStrings.getString("_Error_Could_not1"));
            this.HandleException(e);
            return null;
        }
        if (sqlStatement != null) {
            Statement statement = sqlStatement;
            synchronized (statement) {
                try {
                    if (_QueryTimeout >= 0) {
                        sqlStatement.setQueryTimeout(_QueryTimeout);
                    }
                }
                catch (Throwable throwable) {}
                try {
                    if (_UseEscapeProcessing) {
                        sqlStatement.setEscapeProcessing(_UseEscapeProcessing);
                    }
                }
                catch (Throwable throwable) {}
                try {
                    if (_MaxFieldSize >= 1) {
                        sqlStatement.setMaxFieldSize(_MaxFieldSize);
                    }
                }
                catch (Throwable throwable) {}
                try {
                    if (_MaxRowCount >= 1) {
                        sqlStatement.setMaxRows(_MaxRowCount);
                    }
                }
                catch (Throwable throwable) {}
                try {
                    if (_UseReverseFetch) {
                        sqlStatement.setFetchDirection(1001);
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        _PropertyChangeFlag = false;
        return sqlStatement;
    }

    private synchronized void finalizeStatement(Statement stmt, boolean cancel) {
        Statement statement = stmt;
        synchronized (statement) {
            try {
                if (cancel) {
                    stmt.cancel();
                }
            }
            catch (Throwable t) {
                DatabaseConnection.logEvent(resStrings.getString("_Error_Exception"));
                if (_ShowExceptions) {
                    DatabaseConnection.log(String.valueOf(resStrings.getString("Exception_")) + t);
                }
                if (_ShowStackTraces) {
                    t.printStackTrace();
                }
                this.lastError = t;
            }
            try {
                stmt.clearBatch();
            }
            catch (Throwable throwable) {}
            try {
                stmt.clearWarnings();
            }
            catch (Throwable throwable) {}
            try {
                stmt.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public Vector executeQuery(String SQL, ResultSetViewer Viewer) throws SQLException {
        Vector<Object> Results = new Vector<Object>(1, 1);
        Statement sqlStatement = this.initStatement();
        if (sqlStatement == null) {
            return null;
        }
        try {
            this.CQuery = SQL;
            if (this.mConnection.isClosed()) {
                this.re_init();
            }
            if (_ShowQueries) {
                DatabaseConnection.log(String.valueOf(resStrings.getString("Executing_Query_")) + SQL);
            }
            try {
                this.mConnection.clearWarnings();
            }
            catch (Throwable throwable) {}
            boolean results = sqlStatement.execute(SQL);
            int rowsAffected = sqlStatement.getUpdateCount();
            do {
                if (results) {
                    ResultSet rs = sqlStatement.getResultSet();
                    if (Viewer != null) {
                        Results.addElement(Viewer.modelResultSet(rs));
                    }
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (rowsAffected >= 0) {
                    DatabaseConnection.log(String.valueOf(rowsAffected) + resStrings.getString("Row_s_Affected_"));
                }
                if (!this.mMRFlag) {
                    rowsAffected = -1;
                    results = false;
                    break;
                }
                results = sqlStatement.getMoreResults();
                try {
                    rowsAffected = sqlStatement.getUpdateCount();
                }
                catch (Throwable throwable) {
                    rowsAffected = -1;
                }
            } while (results && rowsAffected != -1);
        }
        catch (SQLException sqle) {
            this.HandleSQLException(sqle, false);
            this.finalizeStatement(sqlStatement, true);
            throw sqle;
        }
        catch (Exception e) {
            this.HandleException(e);
            this.finalizeStatement(sqlStatement, true);
            Results.addElement(Viewer.modelResultSet(null));
        }
        this.finalizeStatement(sqlStatement, false);
        return Results;
    }

    public static final void logEvent(String msg) {
        if (_ShowExceptions) {
            DatabaseConnection.log(msg);
        }
    }

    public static final void log(String msg) {
        System.out.println(msg);
    }

    public final synchronized boolean isClosed() {
        try {
            return !this.mConnection.isClosed();
        }
        catch (Exception exception) {
            return true;
        }
    }

    public synchronized int executeUpdate(String SQLStatement) throws SQLException {
        if (_ShowQueries) {
            if (Thread.currentThread() instanceof BatchRunner) {
                BatchRunner br = (BatchRunner)Thread.currentThread();
                DatabaseConnection.log(String.valueOf(resStrings.getString("Executing_Update_")) + "(" + br.getBatchID() + ") " + SQLStatement);
            } else {
                DatabaseConnection.log(String.valueOf(resStrings.getString("Executing_Update_")) + SQLStatement);
            }
        }
        try {
            this.CQuery = SQLStatement;
            return this.initStatement().executeUpdate(SQLStatement);
        }
        catch (Exception e) {
            this.HandleException(e);
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            return -1;
        }
    }

    private synchronized void HandleSQLException(SQLException se) {
        this.HandleSQLException(se, true);
    }

    private synchronized void HandleSQLException(SQLException se, boolean f) {
        if (f) {
            DatabaseConnection.logEvent(se.toString().concat(String.valueOf(resStrings.getString("Cancelling_Request_")) + this.CQuery + resStrings.getString("KEY1")));
        }
        this.lastError = se;
        if (_ShowStackTraces) {
            se.printStackTrace();
        }
    }

    public static void setMaxRowCount(int count) {
        _MaxRowCount = count;
        _PropertyChangeFlag = true;
    }

    public static void setMaxFieldSize(int fieldsize) {
        _MaxFieldSize = fieldsize;
        _PropertyChangeFlag = true;
    }

    public static void setDriverClassLoader(ClassLoader loader) {
        _DriverLoader = loader;
    }

    public static void setLoginTimeout(int timeout) {
        DriverManager.setLoginTimeout(timeout);
    }

    public static void setQueryTimeout(int timeout) {
        _QueryTimeout = timeout;
        _PropertyChangeFlag = true;
    }

    public static void setVerboseOn(boolean f) {
        _ShowExceptions = f;
        _PropertyChangeFlag = true;
    }

    public static void setDebugOn(boolean f) {
        _ShowStackTraces = f;
        _PropertyChangeFlag = true;
    }

    public static void setQueryEchoOn(boolean f) {
        _ShowQueries = f;
        _PropertyChangeFlag = true;
    }

    public static void setAutoReconnect(boolean f) {
        _EnableAutoReconnect = f;
        _PropertyChangeFlag = true;
    }

    public static void setEscapeProcessingOn(boolean f) {
        _UseEscapeProcessing = f;
        _PropertyChangeFlag = true;
    }

    public static void setFetchMode(boolean f) {
        _UseReverseFetch = f;
        _PropertyChangeFlag = true;
    }

    public static int getMaxRowCount() {
        return _MaxRowCount;
    }

    public static int getMaxFieldSize() {
        return _MaxFieldSize;
    }

    public static int getLoginTimeout() {
        return DriverManager.getLoginTimeout();
    }

    public static int getQueryTimeout() {
        return _QueryTimeout;
    }

    public static boolean getVerboseOn() {
        return _ShowExceptions;
    }

    public static boolean getDebugOn() {
        return _ShowStackTraces;
    }

    public static boolean getQueryEchoOn() {
        return _ShowQueries;
    }

    public static boolean setAutoReconnect() {
        return _EnableAutoReconnect;
    }

    public static boolean getEscapeProcessingOn() {
        return _UseEscapeProcessing;
    }

    public static boolean getFetchMode(boolean f) {
        return _UseReverseFetch;
    }

    public Object[] getAvailableCatalogs() {
        try {
            ResultSet rs = this.getDatabaseInformation().getCatalogs();
            return ResultSetUtilities.getSingleColumn(rs, "TABLE_CAT");
        }
        catch (Throwable t) {
            this.HandleException(t);
            return null;
        }
    }

    public Object[] getAvailableTables() {
        try {
            return this.getAvailableTables(this.getCatalog());
        }
        catch (Throwable t) {
            this.HandleException(t);
            return null;
        }
    }

    public Object[] getAvailableTables(String catalog) {
        try {
            ResultSet rs = this.getDatabaseInformation().getTables(catalog, null, null, new String[]{"TABLE"});
            return ResultSetUtilities.getSingleColumn(rs, "TABLE_NAME");
        }
        catch (Throwable t) {
            this.HandleException(t);
            return null;
        }
    }

    private synchronized void HandleException(Throwable e) {
        this.lastError = e;
        if (e instanceof IOException && _EnableAutoReconnect) {
            try {
                this.re_init();
            }
            catch (SQLException sqle) {
                this.HandleSQLException(sqle);
            }
        } else if (e instanceof SQLException) {
            this.HandleSQLException((SQLException)e);
        } else {
            if (this.CQuery != null) {
                DatabaseConnection.logEvent(String.valueOf(resStrings.getString("Exception_Occurred")) + this.CQuery + resStrings.getString("KEY1"));
            }
            if (_ShowExceptions) {
                DatabaseConnection.log(resStrings.getString("Exception_").concat(e.toString()));
            }
            if (_ShowStackTraces) {
                e.printStackTrace();
            }
        }
    }

    public static int getTypeforName(String name) {
        try {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.sql.Types");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> c = clazz;
            return c.getField(name).getInt(null);
        }
        catch (Exception exception) {
            return 12;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof DatabaseConnection) || o == null) {
            return false;
        }
        DatabaseConnection local = (DatabaseConnection)o;
        return local._url.equalsIgnoreCase(this._url);
    }

    public static String[] getSQLTypes() {
        Vector<String> list = new Vector<String>();
        try {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.sql.Types");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> c = clazz;
            Field[] types = c.getFields();
            int i = 0;
            while (i < types.length) {
                try {
                    list.add(types[i].getName());
                }
                catch (Exception exception) {}
                ++i;
            }
        }
        catch (Exception exception) {}
        return list.toArray(new String[0]);
    }

    private class JDBC_BLOB
    implements Blob {
        File file;
        InputStream is;

        public JDBC_BLOB(File f) {
            this.file = f;
            try {
                this.is = new FileInputStream(this.file);
            }
            catch (Throwable throwable) {}
        }

        public long length() throws SQLException {
            try {
                return this.is.available();
            }
            catch (Throwable throwable) {
                return 0L;
            }
        }

        public byte[] getBytes(long pos, int length) throws SQLException {
            byte[] buff = new byte[length];
            try {
                this.is.reset();
                this.is.skip(pos);
                this.is.read(buff, 0, length);
            }
            catch (Throwable throwable) {}
            return buff;
        }

        public InputStream getBinaryStream() throws SQLException {
            return this.is;
        }

        public long position(byte[] pattern, long start) throws SQLException {
            try {
                this.is.reset();
                this.is.skip(start);
            }
            catch (Throwable throwable) {}
            return start;
        }

        public long position(Blob pattern, long start) throws SQLException {
            return this.position(pattern.getBytes(0L, (int)pattern.length()), start);
        }
    }
}

