/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.lib.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class StringTokenizer
implements Enumeration {
    private int currentPosition = 0;
    private int maxPosition;
    private String str;
    private String delimiters;
    private boolean retTokens;
    private boolean ignoreDoubleTokens;

    public StringTokenizer(String str, String delim, boolean returnTokens, boolean ignoreConsecutiveTokens) {
        this.str = str;
        this.maxPosition = str.length();
        this.delimiters = delim;
        this.retTokens = returnTokens;
        this.ignoreDoubleTokens = ignoreConsecutiveTokens;
    }

    public StringTokenizer(String str, String delim, boolean returnTokens) {
        this(str, delim, false, true);
    }

    public StringTokenizer(String str, String delim) {
        this(str, delim, false, true);
    }

    public StringTokenizer(String str) {
        this(str, " \t\n\r", false, true);
    }

    public synchronized void setReturnTokens(boolean val) {
        this.retTokens = val;
    }

    public String toString() {
        return this.str;
    }

    public synchronized void setString(String str) {
        if (str == null) {
            str = "";
        }
        StringTokenizer stringTokenizer = this;
        synchronized (stringTokenizer) {
            this.currentPosition = 0;
            this.str = str;
            this.maxPosition = this.str.length();
        }
    }

    public synchronized void appendString(String str) {
        if (str == null) {
            return;
        }
        StringTokenizer stringTokenizer = this;
        synchronized (stringTokenizer) {
            this.str = this.str.concat(str);
            this.maxPosition = this.str.length();
        }
    }

    private void skipDelimiters() {
        while (!this.retTokens && this.currentPosition < this.maxPosition && this.delimiters.indexOf(this.str.charAt(this.currentPosition)) >= 0) {
            if (!this.ignoreDoubleTokens) break;
            ++this.currentPosition;
        }
    }

    public boolean hasMoreTokens() {
        this.skipDelimiters();
        return this.currentPosition < this.maxPosition;
    }

    public String nextToken() {
        this.skipDelimiters();
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException();
        }
        int start = this.currentPosition;
        while (this.currentPosition < this.maxPosition && this.delimiters.indexOf(this.str.charAt(this.currentPosition)) < 0) {
            ++this.currentPosition;
        }
        if (!this.retTokens && start == this.currentPosition) {
            ++this.currentPosition;
            return new String(" ");
        }
        ++this.currentPosition;
        return this.str.substring(start, this.currentPosition - 1);
    }

    public String nextToken(String delim) {
        this.delimiters = delim;
        return this.nextToken();
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public synchronized void reset() {
        StringTokenizer stringTokenizer = this;
        synchronized (stringTokenizer) {
            this.currentPosition = 0;
        }
    }

    /*
     * Unable to fully structure code
     */
    public int countTokens() {
        count = 0;
        currpos = this.currentPosition;
        ** GOTO lbl23
        {
            if (!this.ignoreDoubleTokens && this.delimiters.indexOf(this.str.charAt(currpos - 1)) < 0) {
                ++currpos;
            } else if (!this.ignoreDoubleTokens && this.delimiters.indexOf(this.str.charAt(currpos - 1)) >= 0) {
                ++count;
                ++currpos;
            } else if (this.ignoreDoubleTokens) {
                ++currpos;
            }
            do {
                if (!this.retTokens && currpos < this.maxPosition && this.delimiters.indexOf(this.str.charAt(currpos)) >= 0) continue block0;
                if (currpos >= this.maxPosition) break block0;
                start = currpos;
                while (currpos < this.maxPosition && this.delimiters.indexOf(this.str.charAt(currpos)) < 0) {
                    ++currpos;
                }
                if (this.retTokens && start == currpos && this.delimiters.indexOf(this.str.charAt(currpos)) >= 0) {
                    ++currpos;
                }
                ++count;
lbl23:
                // 2 sources

            } while (currpos < this.maxPosition);
        }
        return count;
    }
}

