/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 2003

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
# include <winsock2.h>
# include <windows.h>
# include <stdio.h>
# include <io.h>

SERVICE_STATUS        picoServStatus; 
SERVICE_STATUS_HANDLE picoServStatusHandle;
 
VOID WINAPI picoServStart(DWORD argc, LPTSTR *argv); 
VOID WINAPI picoServCtrlHandler(DWORD opcode);

static char *usage = "usage: %s <port-number> [<command> /INSTALL|/UNINSTALL]";
static BOOL stop = FALSE;
static char *command = 0;
static DWORD portnum = 0;
static char lpServiceName[MAX_PATH];
static SERVICE_TABLE_ENTRY DispatchTable[] = { 
   { lpServiceName, picoServStart }, 
   { NULL,        NULL } 
};

static void
myLog (const char * p, ...)
{
   va_list a;
   static FILE * mylog = 0;

   if (mylog == 0)
      mylog = fopen("C:/picoserv.log", "a+");
   if (mylog >= 0) {
      va_start(a, p);
      vfprintf(mylog, p, a);
      fflush (mylog);
   }
}

VOID SvcDebugOut(LPSTR String, DWORD Status) 
{ 
   CHAR  Buffer[1024]; 
   if (strlen(String) < 1000) { 
      sprintf(Buffer, String, Status); 
      OutputDebugStringA(Buffer); 
   } 
}

void
myError(char *msg)
{
   LPVOID msgBuff;
   char pntBuffer[512];
   char *err = strerror(errno);

   FormatMessage (FORMAT_MESSAGE_ALLOCATE_BUFFER|FORMAT_MESSAGE_FROM_SYSTEM,
                  NULL, GetLastError(),
                  MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
                  (LPTSTR) &msgBuff, 0, NULL);

   wsprintf(pntBuffer, "[PICOSERV] error: %s, code = %d %s\n",
                        msg, GetLastError(), msgBuff);

   OutputDebugStringA (pntBuffer);

   LocalFree(msgBuff);
   ExitProcess(GetLastError());
}

static int 
strcmpic (const char *a, const char *b)
{
   for ( ; *a && *b; a++, b++)
      if (toupper (*a) != toupper(*b))
         break;
   return toupper (*a) - toupper(*b);
}

int
main (int argc, char *argv[]) 
{
   if (argc < 2 || (portnum = atoi(argv[1])) <= 0) {
      fprintf (stderr, usage, argv[0]);
      return 2;
   }
   sprintf (lpServiceName, "picoServ_%d", portnum);

   if (argc == 4) {
      command = argv[2];
      if (portnum <= 0 || strcmpic (argv[3], "/INSTALL") != 0) {
         fprintf (stderr, usage, argv[0]);
         return 2;
      } else {
         SC_HANDLE hSCM = OpenSCManager(NULL, NULL, SC_MANAGER_CREATE_SERVICE);
 	      if (hSCM == NULL) {
		      fprintf (stderr, "Cannot open SCM\n");
            return 2;
         } else {
            SC_HANDLE hService;
	         char filePath[MAX_PATH * 2];
	         GetModuleFileName(NULL, filePath, sizeof(filePath));
            strcat (filePath, " ");
            strcat (filePath, argv[1]);
            strcat (filePath, " \"");
            strcat (filePath, argv[2]);
            strcat (filePath, "\"");

	         hService = CreateService(hSCM,
                               lpServiceName,
                               lpServiceName,
                               SERVICE_ALL_ACCESS,
                               SERVICE_WIN32_OWN_PROCESS,
                               SERVICE_AUTO_START,
                               SERVICE_ERROR_NORMAL,
                               filePath,
                               NULL,
                               NULL,
                               NULL,
                               NULL,
                               NULL);

            CloseServiceHandle(hSCM);
            if (hService == NULL) {
               fprintf (stderr, "Cannot create service");
               return 2;
            } else {
               fprintf (stderr, "Service %s succesfully installed\n", lpServiceName);
               return 0;
            }
         }
         return 0;
      }
   } else if (argc == 3) {
      if (strcmpic (argv[2], "/UNINSTALL") == 0) {
         SC_HANDLE hSCM;
	      SC_HANDLE hService;
         if ((hSCM = OpenSCManager(NULL, NULL, SC_MANAGER_ALL_ACCESS)) != NULL &&
	           (hService = OpenService(hSCM, lpServiceName, DELETE)) != NULL &&
              DeleteService(hService) != FALSE) {
            fprintf (stderr, "Service %s uninstalled", lpServiceName);
         } else {
            fprintf (stderr, "Cannot delete service\n");
         }
         if (hService != NULL)
		      CloseServiceHandle(hService);
         if (hSCM != NULL)
		      CloseServiceHandle(hSCM);
      } else  {
         command = argv[2];
         if (!StartServiceCtrlDispatcher (DispatchTable)) { 
            myError("StartServiceCtrlDispatcher error\n");
         }
      }
   } else {
      fprintf (stderr, usage, argv[0]);
      return 2;
   }
   return 0;
}


void
WINAPI run (char *command, SOCKET sock)
{
   STARTUPINFO si;
   PROCESS_INFORMATION pi;

   memset(&si,0,sizeof(si));
   
   si.cb = sizeof(STARTUPINFO);
   si.dwFlags = STARTF_USESTDHANDLES;
   si.hStdOutput = (HANDLE) sock;
   si.hStdInput  = (HANDLE) sock;
   si.hStdError  = GetStdHandle(STD_ERROR_HANDLE);

   if (!CreateProcess(NULL, (char *) command, NULL, NULL, TRUE,
                      CREATE_NEW_CONSOLE, NULL, NULL, &si, &pi))
      myError("CreateProcess");

   closesocket (sock);
}

VOID WINAPI
picoServStart(DWORD argc, LPTSTR *argv)
{
   struct sockaddr_in sin;
   int namelen = sizeof(sin);
   WSADATA wsaData;
   FILE *out = stdout;
   int foreground = 0;
   SOCKET sock, ns;
   int mainpid;

   DWORD status;

   int i = 0;

   picoServStatus.dwServiceType      = SERVICE_WIN32; 
   picoServStatus.dwCurrentState     = SERVICE_START_PENDING; 
   picoServStatus.dwControlsAccepted = SERVICE_ACCEPT_STOP; /* | SERVICE_ACCEPT_PAUSE_CONTINUE; */
   picoServStatus.dwWin32ExitCode    = 0; 
   picoServStatus.dwServiceSpecificExitCode = 0; 
   picoServStatus.dwCheckPoint       = 0; 
   picoServStatus.dwWaitHint         = 0; 

   picoServStatusHandle = RegisterServiceCtrlHandler( 
      lpServiceName, 
      picoServCtrlHandler); 
 
   if (picoServStatusHandle == (SERVICE_STATUS_HANDLE)0) { 
      SvcDebugOut("[PICOSERV] RegisterServiceCtrlHandler failed %d\n", GetLastError()); 
      return; 
   } 
 
   // Initialization code goes here.
   // command = "C:\\picoSQL-1.4beta\\bin\\picosqld 6789";
   // portnum = 6789;
   if (WSAStartup(MAKEWORD (2,0), &wsaData) != 0) {
      myError ("WSAStartup");
      status = !NO_ERROR;
   } else {
      mainpid = 0;
      if ((sock = WSASocket(AF_INET, SOCK_STREAM, 0, NULL, 0, 0)) < 0) {
         myError("socket");
         status = !NO_ERROR;
      } else {
         sin.sin_family = AF_INET;
         sin.sin_port = htons((unsigned short) portnum); /* Se 0 assegna automaticamente il numero */
         sin.sin_addr.s_addr =  0;
         memset (sin.sin_zero, 0, sizeof(sin.sin_zero));

         setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, "", 0);

         if (bind(sock, (struct sockaddr *)&sin, sizeof(sin)) < 0) {
            myError("bind");
            status = !NO_ERROR;
         } else {
            if (listen(sock, 128) < 0) {
               myError("listen");
               exit(4);
            } else {
               status = NO_ERROR;
            }
         }
      }
   }
 
    // Handle error condition 
    if (status != NO_ERROR) { 
        picoServStatus.dwCurrentState       = SERVICE_STOPPED; 
        picoServStatus.dwCheckPoint         = 0; 
        picoServStatus.dwWaitHint           = 0; 
        picoServStatus.dwWin32ExitCode      = status; 
        picoServStatus.dwServiceSpecificExitCode = WSAGetLastError(); 
 
        SetServiceStatus (picoServStatusHandle, &picoServStatus); 
        return; 
    } 
 
    // Initialization complete - report running status. 
    picoServStatus.dwCurrentState       = SERVICE_RUNNING; 
    picoServStatus.dwCheckPoint         = 0; 
    picoServStatus.dwWaitHint           = 0; 
 
    if (!SetServiceStatus (picoServStatusHandle, &picoServStatus)) { 
        status = GetLastError(); 
        SvcDebugOut(" [PICOSERV] SetServiceStatus error %ld\n",status); 
    } 
 
    // This is where the service does its work. 
   SvcDebugOut(" [PICOSERV] Returning the Main Thread \n",0);
   for ( ; ; ) {
      if ((ns = accept (sock, (struct sockaddr *)&sin, &namelen)) < 0) {
         myError("accept");
	      break;
      } else if (stop) {
         break;
      } else {
         run (command, ns);
      }
   }
   closesocket (sock);
}

VOID WINAPI
picoServCtrlHandler (DWORD Opcode) 
{ 
   DWORD status;
   struct hostent * hp;
   SOCKET sock;

   switch(Opcode) { 
   case SERVICE_CONTROL_STOP:
      stop = TRUE;
      hp = gethostbyname ("localhost");
      picoServStatus.dwCheckPoint    = 0; 
      picoServStatus.dwWaitHint      = 0; 
      if ((sock = socket (AF_INET, SOCK_STREAM, 0)) != INVALID_SOCKET) {
         struct sockaddr_in sin;

         memset (&sin, 0, sizeof(sin));
         memcpy (&sin.sin_addr, hp->h_addr, hp->h_length);
         sin.sin_family = hp->h_addrtype;
         sin.sin_port = htons((unsigned short) portnum);
         if (connect (sock, (struct sockaddr *)&sin, sizeof(sin)) == 0) {
            picoServStatus.dwWin32ExitCode = 0; 
            picoServStatus.dwCurrentState  = SERVICE_STOPPED; 
            closesocket (sock);
            WSACleanup();
            SvcDebugOut("[PICOSERV] Leaving picoServ\n",0); 
         } else {
            picoServStatus.dwWin32ExitCode = WSAGetLastError(); 
            SvcDebugOut("[PICOSERV] Error connecting %ld\n", picoServStatus.dwWin32ExitCode);
         }
      } else {
         picoServStatus.dwWin32ExitCode = WSAGetLastError(); 
         SvcDebugOut("[PICOSERV] Error socket %ld\n", picoServStatus.dwWin32ExitCode);
      }
      if (!SetServiceStatus (picoServStatusHandle, &picoServStatus)) { 
         status = GetLastError(); 
         SvcDebugOut("[PICOSERV] SetServiceStatus error %ld\n",status); 
      }
      return; 
/*
   case SERVICE_CONTROL_PAUSE: 
      // Do whatever it takes to pause here. 
      picoServStatus.dwCurrentState = SERVICE_PAUSED; 
      break; 

   case SERVICE_CONTROL_CONTINUE: 
      // Do whatever it takes to continue here. 
      picoServStatus.dwCurrentState = SERVICE_RUNNING; 
      break; 

*/
   case SERVICE_CONTROL_INTERROGATE: 
      // Fall through to send current status. 
      break; 
   default: 
      SvcDebugOut(" [PICOSERV] Unrecognized opcode %ld\n", Opcode); 
   } 
 
   // Send current status. 
   if (!SetServiceStatus (picoServStatusHandle,  &picoServStatus))  { 
       status = GetLastError(); 
       SvcDebugOut(" [PICOSERV] SetServiceStatus error %ld\n",status); 
    }
    return; 
}
